<?php
/**
 * WooCommerce Template - Compatible with all WooCommerce versions
 * 
 * This template uses hooks and filters instead of template overrides
 * to ensure compatibility with any WooCommerce version
 * 
 * @package Skill Theme
 * @version 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<section class="container mt-5">
    <div class="skill_body d-flex">
        
        <!-- Start Navigation Menu -->
        <?php get_header(); ?>
        <!-- End Navigation Menu -->
        
        <!-- Start Sidebar -->
        <?php get_sidebar(); ?>
        <!-- End Sidebar -->
        
        <div class="content skill_content woocommerce w-100 ms-4 p-4 pb-3 overflow-y-auto">
            
            <!-- Start WooCommerce Cart Display -->
            <?php if (get_theme_mod('skill_cart_display', true)): ?>
                <div class="d-flex justify-content-end">
                    <a target="_blank" href="<?php echo esc_url(wc_get_cart_url()); ?>" class="skill_cart d-flex">
                        <span>
                            <i class="<?php echo esc_attr(get_theme_mod('skill_cart_icon_prefix', 'fas')); ?> <?php echo esc_attr(get_theme_mod('skill_cart_icon', 'fa-shopping-cart')); ?>"></i>
                            <?php echo esc_html(get_theme_mod('skill_cart_text', 'سبدخرید من')); ?>
                        </span>
                        <span class="cart_count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                    </a>
                </div>
            <?php endif; ?>
            <!-- End WooCommerce Cart Display -->
            
            <div class="mt-3 mb-3">
                <?php 
                // Use WooCommerce breadcrumb with compatibility check
                if (function_exists('woocommerce_breadcrumb')) {
                    woocommerce_breadcrumb();
                }
                ?>
            </div>
            
            <?php 
            // Use WooCommerce content with compatibility check
            if (function_exists('woocommerce_content')) {
                woocommerce_content();
            }
            ?>
            
        </div>
        
    </div>
</section>

<?php get_footer(); ?>