<?php if (get_theme_mod('skill_footer_display', true)) : ?>
<!-- ===== Footer: Gradient Inverse / Minimal ===== -->
<footer class="mh-footer" dir="rtl">
    <div class="mh-footer__glow" aria-hidden="true"></div>
  
    <div class="mh-footer__inner">
      <!-- Branding center -->
      <div class="mh-footer__brand">
        
        <svg class="mh-logo" width="42" height="42" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
          <path d="M12 2l7.5 4.33v11.34L12 22l-7.5-4.33V6.33L12 2zm0 2.31L6 6.77v10.46l6 3.46 6-3.46V6.77L12 4.31z"/>
          <circle cx="12" cy="12" r="3.5"/>
        </svg>
        <div class="mh-title">
          <strong><?php $val = function_exists('skill_footer_text') ? skill_footer_text('skill_footer_name', __('محمد حیدری', 'skill')) : get_theme_mod('skill_footer_name', __('محمد حیدری', 'skill')); echo esc_html(function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_name', $val) : $val); ?></strong>
          <span><?php $job = function_exists('skill_footer_text') ? skill_footer_text('skill_footer_job', __('برنامه‌نویس', 'skill')) : get_theme_mod('skill_footer_job', __('برنامه‌نویس', 'skill')); echo esc_html(function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_job', $job) : $job); ?></span>
        </div>
      </div>
  
      <!-- Quick links -->
      <nav class="mh-footer__nav" aria-label="لینک‌های سریع">
        <?php $about_link = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_about_link', get_theme_mod('skill_footer_about_link', '#about')) : get_theme_mod('skill_footer_about_link', '#about'); ?>
        <?php $about_text = function_exists('skill_footer_text') ? skill_footer_text('skill_footer_about_text', __('درباره‌من', 'skill')) : get_theme_mod('skill_footer_about_text', __('درباره‌من', 'skill')); ?>
        <a href="<?php echo esc_url($about_link); ?>"><?php echo esc_html(function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_about_text', $about_text) : $about_text); ?></a>
        <?php $projects_link = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_projects_link', get_theme_mod('skill_footer_projects_link', '#projects')) : get_theme_mod('skill_footer_projects_link', '#projects'); ?>
        <?php $projects_text = function_exists('skill_footer_text') ? skill_footer_text('skill_footer_projects_text', __('نمونه‌کارها', 'skill')) : get_theme_mod('skill_footer_projects_text', __('نمونه‌کارها', 'skill')); ?>
        <a href="<?php echo esc_url($projects_link); ?>"><?php echo esc_html(function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_projects_text', $projects_text) : $projects_text); ?></a>
        <?php $skills_link = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_skills_link', get_theme_mod('skill_footer_skills_link', '#skills')) : get_theme_mod('skill_footer_skills_link', '#skills'); ?>
        <?php $skills_text = function_exists('skill_footer_text') ? skill_footer_text('skill_footer_skills_text', __('مهارت‌ها', 'skill')) : get_theme_mod('skill_footer_skills_text', __('مهارت‌ها', 'skill')); ?>
        <a href="<?php echo esc_url($skills_link); ?>"><?php echo esc_html(function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_skills_text', $skills_text) : $skills_text); ?></a>
        <?php $contact_link = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_contact_link', get_theme_mod('skill_footer_contact_link', '#contact')) : get_theme_mod('skill_footer_contact_link', '#contact'); ?>
        <?php $contact_text = function_exists('skill_footer_text') ? skill_footer_text('skill_footer_contact_text', __('ارتباط', 'skill')) : get_theme_mod('skill_footer_contact_text', __('ارتباط', 'skill')); ?>
        <a href="<?php echo esc_url($contact_link); ?>"><?php echo esc_html(function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_contact_text', $contact_text) : $contact_text); ?></a>
        <?php $resume_url = get_theme_mod('skill_footer_resume_url'); ?>
        <?php if ($resume_url) : ?>
        <?php $resume_link = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_resume_url', $resume_url) : $resume_url; ?>
        <?php $resume_text = function_exists('skill_footer_text') ? skill_footer_text('skill_footer_resume_text', __('دانلود رزومه', 'skill')) : get_theme_mod('skill_footer_resume_text', __('دانلود رزومه', 'skill')); ?>
        <a href="<?php echo esc_url($resume_link); ?>" download><?php echo esc_html(function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_footer_resume_text', $resume_text) : $resume_text); ?></a>
        <?php endif; ?>
      </nav>
  
      <!-- Social -->
      <div class="mh-footer__social" aria-label="شبکه‌های اجتماعی">
        <?php $tg = get_theme_mod('skill_social_telegram'); if ($tg) { $tg = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_social_telegram', $tg) : $tg; } ?>
        <?php if (!empty($tg)) : ?>
        <a href="<?php echo esc_url($tg); ?>" aria-label="تلگرام">
          <!-- Telegram -->
          <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M9.04 15.47l-.37 5.28c.53 0 .76-.23 1.03-.51l2.47-2.37 5.12 3.75c.94.52 1.61.25 1.86-.86l3.37-15.8h0c.3-1.4-.5-1.95-1.4-1.6L1.77 10.06c-1.36.53-1.34 1.3-.23 1.64l5.24 1.64 12.17-7.68c.57-.38 1.08-.17.66.21"/></svg>
        </a>
        <?php endif; ?>
        <?php $li = get_theme_mod('skill_social_linkedin'); if ($li) { $li = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_social_linkedin', $li) : $li; } ?>
        <?php if (!empty($li)) : ?>
        <a href="<?php echo esc_url($li); ?>" aria-label="لینکدین">
          <!-- LinkedIn -->
          <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1 4.98 2.12 4.98 3.5zM0 8h5v16H0V8zm7.5 0h4.8v2.2h.1c.67-1.27 2.3-2.6 4.73-2.6 5.06 0 6 3.33 6 7.66V24h-5v-7.2c0-1.72-.03-3.93-2.4-3.93-2.4 0-2.77 1.87-2.77 3.8V24h-5V8z"/></svg>
        </a>
        <?php endif; ?>
        <?php $gh = get_theme_mod('skill_social_github'); if ($gh) { $gh = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_social_github', $gh) : $gh; } ?>
        <?php if (!empty($gh)) : ?>
        <a href="<?php echo esc_url($gh); ?>" aria-label="گیت‌هاب">
          <!-- GitHub -->
          <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M12 .5a12 12 0 00-3.79 23.4c.6.11.82-.26.82-.58 0-.29-.01-1.05-.02-2.07-3.34.73-4.04-1.61-4.04-1.61-.55-1.39-1.35-1.76-1.35-1.76-1.1-.75.08-.73.08-.73 1.22.09 1.86 1.25 1.86 1.25 1.08 1.85 2.82 1.31 3.5 1 .11-.79.42-1.31.76-1.61-2.66-.31-5.47-1.33-5.47-5.93 0-1.31.47-2.38 1.24-3.22-.12-.31-.54-1.56.12-3.25 0 0 1.01-.32 3.3 1.23a11.5 11.5 0 016 0c2.29-1.55 3.3-1.23 3.3-1.23.66 1.69.24 2.94.12 3.25.77.84 1.24 1.91 1.24 3.22 0 4.61-2.81 5.61-5.49 5.92.43.37.81 1.1.81 2.22 0 1.6-.02 2.89-.02 3.28 0 .32.22.7.83.58A12 12 0 0012 .5z"/></svg>
        </a>
        <?php endif; ?>
        <?php $em = get_theme_mod('skill_social_email'); if ($em) { $em = function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_social_email', $em) : $em; } ?>
        <?php if (!empty($em)) : ?>
        <a href="mailto:<?php echo esc_attr($em); ?>" aria-label="ایمیل">
          <!-- Mail -->
          <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M20 4H4c-1.1 0-2 .9-2 2v12a2 2 0 002 2h16a2 2 0 002-2V6a2 2 0 00-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/></svg>
        </a>
        <?php endif; ?>
      </div>
  
      <!-- Bottom line -->
      <div class="mh-footer__bottom">
        <p><?php $val = function_exists('skill_footer_text') ? skill_footer_text('skill_edit_footer', __('© تمامی حقوق محفوظ است. کپی به هرشکل غیرمجاز و غیرقانونی است.', 'skill')) : get_theme_mod('skill_edit_footer', __('© تمامی حقوق محفوظ است. کپی به هرشکل غیرمجاز و غیرقانونی است.', 'skill')); echo esc_html(function_exists('skill_wpml_admin_text') ? skill_wpml_admin_text('skill_edit_footer', $val) : $val); ?></p>
      </div>
    </div>
  </footer>

<?php endif; ?>
<script src="<?php bloginfo('template_url'); ?>/assets/js/jquery-3.7.1.min.js"></script>
<script src="<?php bloginfo('template_url'); ?>/assets/js/bootstrap.min.js"></script>
<script src="<?php bloginfo('template_url'); ?>/assets/js/swiper-bundle.min.js"></script>
<script src="<?php bloginfo('template_url'); ?>/assets/js/main.js"></script>
<?php wp_footer(); ?>
</body>
</html>
