<section class="container mt-5">
    <div class="skill_body d-flex">
        <?php get_header(); ?>
        <?php get_sidebar(); ?>

        <div class="content skill_content w-100 ms-4 p-4 pb-3 overflow-y-auto">
            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                <div class="container mt-5">
                    <div class="info_post">
                        <h1><?php the_title(); ?></h1>
                    </div>

                    <?php if (get_theme_mod('skill_single_show_date', true) || get_theme_mod('skill_single_show_author', true) || get_theme_mod('skill_single_show_category', true)) : ?>
                        <div class="mt-4">
                            <div class="post_meta me-3">
                                <?php if (get_theme_mod('skill_single_show_date', true)) : ?>
                                    <span class="me-3"><i class="fas fa-clock"></i> <?php echo skill_get_persian_post_date_conditional('j F Y'); ?></span>
                                <?php endif; ?>

                                <?php if (get_theme_mod('skill_single_show_author', true)) : ?>
                                    <span class="me-3"><i class="fas fa-user"></i> <?php the_author(); ?></span>
                                <?php endif; ?>

                                <?php if (get_theme_mod('skill_single_show_category', true)) : ?>
                                    <span class="skill_cat me-3"><i class="fas fa-folder-open"></i> <?php the_category(' - '); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if (get_theme_mod('skill_single_show_breadcrumb', true)) : ?>
                        <div class="skill_links-back mb-5 mt-4">
                            <?php simple_persian_breadcrumbs(); ?>
                        </div>
                    <?php endif; ?>

                    <div class="content_single">
                        <?php if (get_theme_mod('skill_single_show_thumbnail', true) && has_post_thumbnail()) : ?>
                            <div class="img_post mt-3">
                                <?php the_post_thumbnail(get_theme_mod('skill_single_thumbnail_size', 'large')); ?>
                            </div>
                        <?php endif; ?>

                        <div class="desc_single mt-5">
                            <?php the_content(); ?>
                        </div>

                        <?php if (get_theme_mod('skill_single_show_tags', true) || get_theme_mod('skill_single_show_social', true)) : ?>
                            <div class="skill_blog_link_info_share d-flex justify-content-between mt-4">
                                <?php if (get_theme_mod('skill_single_show_social', true)) : ?>
                                    <div class="social d-flex align-items-center">
                                        <span class="me-2"><?php _e('اشتراک گذاری:', 'skill'); ?></span>
                                        <ul class="d-flex p-0">
                                            <?php
                                            $networks = get_option('social_sharing_networks', array());
                                            foreach ($networks as $network) {
                                                if (!empty($network['url']) && !empty($network['icon'])) {
                                                    echo '<li class="me-2"><a href="' . esc_url($network['url']) . '"><i class="' . esc_attr($network['icon']) . '"></i></a></li>';
                                                }
                                            }
                                            ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>

                                <?php if (get_theme_mod('skill_single_show_tags', true)) : ?>
                                    <div class="label_post d-flex align-items-center">
                                        <div class="d-flex align-items-center mb-0 ps-0">
                                            <?php the_tags(__(' برچسب ها: ', 'skill'), ''); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if (get_theme_mod('skill_single_show_author_box', true)) : ?>
                        <div class="author-box mt-5 p-4">
                            <div class="d-flex align-items-center">
                                <div class="author-avatar me-3">
                                    <?php echo get_avatar(get_the_author_meta('ID'), 80); ?>
                                </div>
                                <div class="author-info">
                                    <h4><?php the_author(); ?></h4>
                                    <p><?php echo get_the_author_meta('description'); ?></p>
                                    <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>" class="btn btn-sm btn-primary">
                                        <?php _e('مطالب بیشتر از این نویسنده', 'skill'); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if (get_theme_mod('skill_single_show_related', true)) : ?>
                        <div class="related-posts mt-5">
                            <h3 class="mb-4"><?php _e('مطالب مرتبط', 'skill'); ?></h3>
                            <div class="row">
                                <?php
                                $related_count = get_theme_mod('skill_single_related_count', 3);
                                $categories = get_the_category();
                                $category_ids = array();

                                foreach($categories as $category) {
                                    $category_ids[] = $category->term_id;
                                }

                                $args = array(
                                    'category__in' => $category_ids,
                                    'post__not_in' => array(get_the_ID()),
                                    'posts_per_page' => $related_count,
                                    'ignore_sticky_posts' => 1
                                );

                                $related_query = new WP_Query($args);

                                if ($related_query->have_posts()) :
                                    while ($related_query->have_posts()) : $related_query->the_post(); ?>
                                        <div class="col-md-<?php echo 12 / $related_count; ?> mb-4">
                                            <div class="card h-100">
                                                <?php if (has_post_thumbnail()) : ?>
                                                    <a href="<?php the_permalink(); ?>">
                                                        <?php the_post_thumbnail('medium', array('class' => 'card-img-top')); ?>
                                                    </a>
                                                <?php endif; ?>
                                                <div class="card-body">
                                                    <h5 class="card-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                                                    <p class="card-text"><?php echo wp_trim_words(get_the_excerpt(), 15); ?></p>
                                                </div>
                                                <div class="card-footer">
                                                    <small class="text-muted"><?php echo skill_get_persian_post_date_conditional('j F Y'); ?></small>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile;
                                endif;

                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php
                    
                    $post_id = get_the_ID();
                    $rating = (int)get_post_meta($post_id, 'skill_post_rating', true);
                    $rating_count = (int)get_post_meta($post_id, 'skill_post_rating_count', true);
                    $average = ($rating_count > 0) ? round($rating / $rating_count, 2) : 0;
                   
                    $average = min($average, 5);
                    ?>
                    <div class="skill-post-rating my-5 text-center">
                        <div class="rating-stars d-inline-flex flex-row-reverse justify-content-center" data-post="<?php echo esc_attr($post_id); ?>">
                            <?php 
                            
                            $user_ip = $_SERVER['REMOTE_ADDR'];
                            $voted_ips = get_post_meta($post_id, 'skill_post_rating_ips', true);
                            $user_has_voted = is_array($voted_ips) && in_array($user_ip, $voted_ips);
                            
                            for ($i = 5; $i >= 1; $i--) : 
                               
                                $star_class = 'far fa-star';
                                if ($user_has_voted && $average > 0) {
                                    if ($i <= $average) {
                                        $star_class = 'fas fa-star';
                                    }
                                }
                            ?>
                                <button class="star-btn border-0 bg-transparent p-0 mx-1" data-star="<?php echo $i; ?>" aria-label="<?php printf( esc_attr__('Give %d stars', 'skill'), $i ); ?>">
                                    <i class="<?php echo $star_class; ?> fa-2x"></i>
                                </button>
                            <?php endfor; ?>
                        </div>
                        <div class="rating-info mt-2">
                            <span class="average-rating">
                                <?php printf( esc_html__('امتیاز: %s از 5', 'skill'), $average ); ?>
                            </span>
                            <span class="rating-count ms-2">
                                (<?php printf( esc_html__('%d رای', 'skill'), (int)$rating_count ); ?>)
                            </span>
                        </div>
                        <div class="rating-message mt-2 text-success" style="display:none;"></div>
                    </div>
                </div>

                <?php if (get_theme_mod('skill_single_show_comments', true)) : ?>
                    <div class="post_comments mt-5">
                        <?php comments_template(); ?>
                    </div>
                <?php endif; ?>

            <?php endwhile; else : ?>
                <p><?php _e('متاسفانه چیزی برای نمایش وجود نداره.', 'skill'); ?></p>
            <?php endif; ?>
            <!-- Footer inside content but with negative margins to break out of padding -->
            <div class="footer-full-width">
                <?php get_template_part('template-part-footer-content'); ?>
            </div>
        </div>
    </div>
</section>