<?php
/**
 * Template for displaying single project posts
 * 
 * @package Skill
 */

?>
<section class="container mt-5">
    <div class="skill_body d-flex">
        <?php get_header(); ?>
        <?php get_sidebar(); ?>

        <div class="content skill_content w-100 ms-4 p-4 pb-3 overflow-y-auto">
            <main id="primary" class="site-main single-project">
                <?php while (have_posts()) : the_post(); ?>
                    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <header class="project-header">
                            <h1 class="project-title"><?php the_title(); ?></h1>

                            <?php if (get_theme_mod('skill_project_show_meta', true)) : ?>
                                <?php
                                $client_name = get_post_meta(get_the_ID(), '_client_name', true);
                                $start_number = get_post_meta(get_the_ID(), '_start_number', true);
                                $end_number = get_post_meta(get_the_ID(), '_end_number', true);
                                $project_address = get_post_meta(get_the_ID(), '_project_address', true);
                                ?>
                                <div class="project-meta">
                                    <?php if ($client_name) : ?>
                                        <div class="project-meta-item">
                                            <i class="fas fa-user-tie"></i>
                                            <span><?php echo esc_html($client_name); ?></span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($start_number) : ?>
                                        <div class="project-meta-item">
                                            <i class="fas fa-hashtag"></i>
                                            <span><?php echo esc_html($start_number); ?></span>
                                            <?php if ($end_number) : ?>
                                                <span> - <?php echo esc_html($end_number); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($project_address) : ?>
                                        <a href="<?php echo esc_url($project_address); ?>" target="_blank" class="project-meta-item">
                                            <i class="fas fa-link"></i>
                                            <span><?php echo esc_html($project_address); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </header>

                        <?php if (get_theme_mod('skill_project_show_thumbnail', true) && has_post_thumbnail()) : ?>
                            <div class="project-thumbnail">
                                <?php the_post_thumbnail(get_theme_mod('skill_project_thumbnail_size', 'large'), array('class' => 'project-featured-image')); ?>
                            </div>
                        <?php endif; ?>

                        <div class="project-content">
                            <?php the_content(); ?>
                        </div>

                        <!-- Enhanced Project Information Display -->
                        <?php if (get_theme_mod('skill_project_show_enhanced_info', true)) : ?>
                            <?php skill_display_project_info(); ?>
                        <?php endif; ?>

                        <!-- Project Gallery -->
                        <?php if (get_theme_mod('skill_project_show_gallery', true)) : ?>
                            <?php skill_display_project_gallery(); ?>
                        <?php endif; ?>

                        <!-- Project Timeline -->
                        <?php if (get_theme_mod('skill_project_show_timeline', true)) : ?>
                            <?php skill_display_project_timeline(); ?>
                        <?php endif; ?>

                        <!-- Project Team -->
                        <?php if (get_theme_mod('skill_project_show_team', true)) : ?>
                            <?php skill_display_project_team(); ?>
                        <?php endif; ?>

                        <!-- Project Links -->
                        <?php if (get_theme_mod('skill_project_show_links', true)) : ?>
                            <?php skill_display_project_links(); ?>
                        <?php endif; ?>

                        <?php if (get_theme_mod('skill_project_show_technologies', true) || get_theme_mod('skill_project_show_details', true)) : ?>
                            <div class="project-details-grid">
                                <?php if (get_theme_mod('skill_project_show_technologies', true) && ($technologies = get_post_meta(get_the_ID(), '_technologies', true))) : ?>
                                    <div class="project-detail-card">
                                        <h3><?php _e('تکنولوژی های استفاده شده', 'skill'); ?></h3>
                                        <div class="project-technologies">
                                            <div class="tech-badges">
                                                <?php
                                                $tech_list = explode(',', $technologies);
                                                foreach ($tech_list as $tech) :
                                                    $tech = trim($tech);
                                                    if (!empty($tech)) : ?>
                                                        <span class="tech-badge"><?php echo esc_html($tech); ?></span>
                                                    <?php endif;
                                                endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if (get_theme_mod('skill_project_show_details', true)) : ?>
                                    <div class="project-detail-card">
                                        <h3><?php _e('جزئیات پروژه', 'skill'); ?></h3>
                                        <ul class="project-details-list">
                                            <?php if ($client_name) : ?>
                                                <li><strong><?php _e('مشتری:', 'skill'); ?></strong> <?php echo esc_html($client_name); ?></li>
                                            <?php endif; ?>

                                            <?php if ($start_number) : ?>
                                                <li><strong><?php _e('مدت زمان:', 'skill'); ?></strong>
                                                    <?php echo esc_html($start_number); ?>
                                                    <?php if ($end_number) : ?>
                                                        <?php _e('تا', 'skill'); ?> <?php echo esc_html($end_number); ?>
                                                    <?php endif; ?>
                                                </li>
                                            <?php endif; ?>

                                            <?php if ($project_address) : ?>
                                                <li><strong><?php _e('آدرس:', 'skill'); ?></strong> <?php echo esc_html($project_address); ?></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <?php if (get_theme_mod('skill_project_show_categories', true) && has_term('', 'project_category')) : ?>
                            <div class="project-categories-wrapper">
                                <h3 class="categories-title"><?php _e('دسته‌بندی‌های پروژه', 'skill'); ?></h3>
                                <div class="project-categories">
                                    <?php
                                    $terms = get_the_terms(get_the_ID(), 'project_category');
                                    foreach ($terms as $term) {
                                        echo '<span class="project-category-badge">' . esc_html($term->name) . '</span>';
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php endif; ?>

                    </article>
                <?php endwhile; ?>

                <?php if (get_theme_mod('skill_project_show_comments', false) && (comments_open() || get_comments_number())) : ?>
                    <?php comments_template(); ?>
                <?php endif; ?>
            </main>
           <!-- Footer inside content but with negative margins to break out of padding -->
           <?php if (function_exists('skill_add_language_switcher_bottom_left')) { skill_add_language_switcher_bottom_left(); } ?>
           <div class="footer-full-width">
                <?php get_template_part('template-part-footer-content'); ?>
            </div>
        </div>
    </div>
</section>

