<section class="container mt-5">

    <div class="skill_body d-flex">

        <!--    Start Nav Menu-->
        <?php get_header(); ?>
        <!--    End Nav Menu-->

        <!--    Start My Info-->
        <?php get_sidebar(); ?>
        <!--    End My Info-->

        <div class="content skill_content w-100 ms-4 p-4 pb-3 overflow-x-auto">

            

                <div class="mt-5">

                    <div class="services mb-4 d-flex align-items-center justify-content-between">
                        <span> <i class="fa-solid fa-layer-group"></i> <?php wp_title(''); ?></span>
                        <div class="view-toggle" role="group" aria-label="toggle view">
                            <button class="btn btn-sm btn-light me-2 toggle-grid active" data-view="grid" title="نمایش شبکه‌ای">
                                <i class="fa-solid fa-grip"></i>
                            </button>
                            <button class="btn btn-sm btn-light toggle-list" data-view="list" title="نمایش کارتی عریض">
                                <i class="fa-solid fa-list"></i>
                            </button>
                        </div>
                    </div>

                    <div class="container_boxe d-grid" data-view-container>
                        <?php 
                        // Build a single query (optionally filtered by selected categories)
                        $enable_category_filter = get_theme_mod('skill_blog_archive_enable_category_filter', false);
                        $selected_categories = array();
                        if ($enable_category_filter) {
                            $categories = get_categories(array(
                                'hide_empty' => false,
                                'orderby' => 'name',
                                'order' => 'ASC'
                            ));
                            foreach ($categories as $category) {
                                if (get_theme_mod('skill_blog_archive_category_' . $category->term_id, false)) {
                                    $selected_categories[] = $category->term_id;
                                }
                            }
                        }

                        $use_custom_query = !empty($selected_categories);
                        if ($use_custom_query) {
                            $paged = get_query_var('paged') ? get_query_var('paged') : 1;
                            $the_query = new WP_Query([
                                'post_type' => 'post',
                                'paged' => $paged,
                                'category__in' => $selected_categories,
                            ]);
                        } else {
                            global $wp_query; 
                            $the_query = $wp_query; 
                        }

                        if ($the_query->have_posts()) : while ($the_query->have_posts()) : $the_query->the_post(); ?>
                        <div class="boxes">
                            <div class="img mb-3 overflow-hidden">
                                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?>
                                    <div class="archive-title-overlay"><span><?php the_title(); ?></span></div>
                                </a>
                            </div>
                            <div class="content_boxs">
                                <div class="post-meta-author"><i class="fa-solid fa-pen ms-1"></i> <?php echo get_the_author(); ?></div>
                                <div class="post-excerpt">
                                <?php 
                                if (get_theme_mod('skill_blog_archive_show_excerpt', true)) {
                                    $excerpt_length = get_theme_mod('skill_blog_archive_excerpt_length', 20);
                                    echo wp_kses_post(wp_trim_words(get_the_excerpt(), $excerpt_length));
                                } else {
                                    the_excerpt();
                                }
                                ?>
                                </div>
                                <div class="post-footer">
                                    <span class="post-date"><i class="fa fa-calendar-alt me-1"></i> <?php echo skill_get_persian_post_date_conditional('j F Y'); ?></span>
                                    <a href="<?php the_permalink(); ?>" class="btn-more">
                                        <span class="btn-more-text"><?php _e('بیشتر', 'skill'); ?></span>
                                        <span class="btn-more-icon"><i class="fa-solid fa-arrow-left"></i></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; else : ?>
                            <p><?php _e( 'متاسفانه چیزی برای نمایش وجود نداره.', 'skill' ); ?></p>
                        <?php endif; 
                        if ($use_custom_query) { wp_reset_postdata(); }
                        ?>
                    </div>

                    <div class="row">
                        <div class="d-flex justify-content-center mt-4">
                            <?php 
                            // Unified pagination based on the query used above
                            $current_paged = max(1, get_query_var('paged'));
                            $total_pages = isset($the_query) && $the_query instanceof WP_Query ? $the_query->max_num_pages : ( isset($wp_query) ? $wp_query->max_num_pages : 1 );
                            if ($total_pages > 1) : ?>
                                <div class="archive_pagination">
                                    <?php 
                                    echo paginate_links(array(
                                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                                        'format' => '?paged=%#%',
                                        'current' => $current_paged,
                                        'total' => $total_pages,
                                        'prev_text' => __(' قبلی', 'skill'),
                                        'next_text' => __(' بعدی', 'skill')
                                    )); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>

                <!-- Footer inside content but with negative margins to break out of padding -->
                <div class="footer-full-width">
                    <?php get_template_part('template-part-footer-content'); ?>
                </div>
                
            

        </div>

    </div>

</section>

