<?php

//**************** setting social share ****************//
function social_sharing_admin_menu() {
    add_menu_page(
        __('تنظیمات شبکه های اجتماعی', 'skill'),
        __('شبکه های اجتماعی', 'skill'),
        'manage_options',
        'social-sharing-settings',
        'social_sharing_settings_page',
        'dashicons-share',
        25
    );
}
add_action('admin_menu', 'social_sharing_admin_menu');

function social_sharing_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php _e('تنظیمات اشتراک گذاری', 'skill'); ?></h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('social_sharing_settings');
            do_settings_sections('social-sharing-settings');
            submit_button();
            ?>

            <div id="social-networks-container">
                <?php
                $networks = get_option('social_sharing_networks', array());
                foreach ($networks as $index => $network) {
                    echo social_network_field($index, $network);
                }
                ?>
            </div>

            <button type="button" id="add-social-network" class="button"><?php _e('افزودن شبکه اجتماعی', 'skill'); ?></button>
        </form>
    </div>

    <script>
        jQuery(document).ready(function($) {
            $('#add-social-network').click(function() {
                const index = Date.now();
                $.post(ajaxurl, {
                    action: 'get_social_network_field',
                    index: index
                }, function(response) {
                    $('#social-networks-container').append(response);
                });
            });

            $(document).on('click', '.remove-social-network', function() {
                $(this).closest('.social-network-field').remove();
            });
        });
    </script>
    <?php
}

function social_network_field($index, $network = array()) {
    $network = wp_parse_args($network, array(
        'name' => '',
        'icon' => '',
        'url' => ''
    ));

    return '
    <div class="social-network-field" style="margin-bottom: 15px; padding: 15px; border: 1px solid #ddd;">
        <div style="margin-bottom: 10px;">
            <label>' . esc_html__('نام شبکه اجتماعی', 'skill') . '</label>
            <input type="text" name="social_sharing_networks[' . $index . '][name]" value="' . esc_attr($network['name']) . '" class="widefat">
        </div>
        <div style="margin-bottom: 10px;">
            <label>'. esc_html__('آیکون (کلاس Font Awesome)', 'skill') .'</label>
            <input type="text" name="social_sharing_networks[' . $index . '][icon]" value="' . esc_attr($network['icon']) . '" class="widefat" placeholder="' . esc_attr__('مثال: fa-brands fa-telegram', 'skill') . '">
        </div>
        <div style="margin-bottom: 10px;">
            <label>'. esc_html__('URL اشتراک گذاری' , 'skill') .'</label>
            <input type="url" name="social_sharing_networks[' . $index . '][url]" value="' . esc_url($network['url']) . '" class="widefat">
        </div>
        <button type="button" class="button remove-social-network">'. esc_html__('حذف', 'skill') .'</button>
    </div>';
}

function register_social_sharing_settings() {
    register_setting('social_sharing_settings', 'social_sharing_networks');
}
add_action('admin_init', 'register_social_sharing_settings');

function get_social_network_field_ajax() {
    $index = isset($_POST['index']) ? intval($_POST['index']) : 0;
    echo social_network_field($index);
    wp_die();
}
add_action('wp_ajax_get_social_network_field', 'get_social_network_field_ajax');
//**************** end setting social share ****************//