<?php

// Register meta box for per-page scroll control
add_action('add_meta_boxes', function () {
    add_meta_box(
        'skill_scroll_control',
        __('تنظیمات اسکرول صفحه', 'skill'),
        function ($post) {
            $value = get_post_meta($post->ID, '_skill_disable_scrollbar', true);
            wp_nonce_field('skill_scroll_control_nonce', 'skill_scroll_control_nonce_field');
            ?>
            <p>
                <label>
                    <input type="checkbox" name="skill_disable_scrollbar" value="1" <?php checked($value, '1'); ?> />
                    <?php _e('مخفی کردن اسکرول‌بار (بدون غیرفعال کردن اسکرول)', 'skill'); ?>
                </label>
            </p>
            <?php
        },
        array('page','post','project'),
        'side',
        'high'
    );
});

// Save meta box value
add_action('save_post', function ($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    if (!isset($_POST['skill_scroll_control_nonce_field']) || !wp_verify_nonce($_POST['skill_scroll_control_nonce_field'], 'skill_scroll_control_nonce')) {
        return;
    }
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    $enabled = isset($_POST['skill_disable_scrollbar']) && $_POST['skill_disable_scrollbar'] === '1' ? '1' : '';
    if ($enabled) {
        update_post_meta($post_id, '_skill_disable_scrollbar', '1');
    } else {
        delete_post_meta($post_id, '_skill_disable_scrollbar');
    }
});

// Add body class when scroll is disabled for the current page
add_filter('body_class', function ($classes) {
    $post_id = 0;
    if (is_singular(array('page','post','project'))) {
        $post_id = get_queried_object_id();
    } elseif (is_home()) {
        $post_id = (int) get_option('page_for_posts');
    }
    if ($post_id && get_post_meta($post_id, '_skill_disable_scrollbar', true) === '1') {
        $classes[] = 'skill-no-scroll';
    }
    return $classes;
});

// Output CSS to hide scrollbar while keeping scroll functional
// Does not require body_class and does not alter body classes
add_action('wp_head', function () {
    $post_id = 0;
    if (is_singular(array('page','post','project'))) {
        $post_id = get_queried_object_id();
    } elseif (is_home()) {
        $post_id = (int) get_option('page_for_posts');
    }
    if ($post_id && get_post_meta($post_id, '_skill_disable_scrollbar', true) === '1') {
        echo '<style id="skill-scroll-control">/* Hide all scrollbars on this page only; keep layout/overflow intact */
        *,html,body{scrollbar-width:none !important;-ms-overflow-style:none !important}
        *::-webkit-scrollbar,html::-webkit-scrollbar,body::-webkit-scrollbar{width:0 !important;height:0 !important}
        *::-webkit-scrollbar-thumb,html::-webkit-scrollbar-thumb,body::-webkit-scrollbar-thumb{background:transparent !important;border:none !important}
        *::-webkit-scrollbar-track,html::-webkit-scrollbar-track,body::-webkit-scrollbar-track{background:transparent !important;border:none !important}
        </style>';
    }
});

// Removed JS padding compensation to avoid layout issues

// No JS needed; scrolling remains functional

?>