<?php

// Metabox for custom header and footer
function skill_add_header_footer_metabox() {
    add_meta_box(
        'skill_header_footer_metabox',
        __('انتخاب هدر و فوتر سفارشی', 'skill'),
        'skill_header_footer_metabox_callback',
        ['page', 'project', 'post'],
        'side'
    );
}
add_action('add_meta_boxes', 'skill_add_header_footer_metabox');

function skill_header_footer_metabox_callback($post) {
    wp_nonce_field('skill_header_footer_nonce', 'skill_header_footer_nonce');
    $header_id = get_post_meta($post->ID, '_skill_custom_header', true);
    $footer_id = get_post_meta($post->ID, '_skill_custom_footer', true);

    // Show only elementary tabs
    $args = [
        'post_type' => 'page',
        'posts_per_page' => -1,
        'meta_key' => '_elementor_edit_mode',
        'meta_value' => 'builder'
    ];
    $pages = get_posts($args);

    echo '<label for="skill_custom_header">' . __('هدر سفارشی:', 'skill') . '</label><br>';
    echo '<select name="skill_custom_header" id="skill_custom_header">';
    echo '<option value="">-- ' . __('بدون هدر', 'skill') . ' --</option>';
    foreach ($pages as $page) {
        $selected = selected($header_id, $page->ID, false);
        echo '<option value="' . esc_attr($page->ID) . '" ' . $selected . '>' . esc_html($page->post_title) . '</option>';
    }
    echo '</select><br><br>';

    echo '<label for="skill_custom_footer">' . __('فوتر سفارشی:', 'skill') . '</label><br>';
    echo '<select name="skill_custom_footer" id="skill_custom_footer">';
    echo '<option value="">-- ' . __('بدون فوتر', 'skill') . ' --</option>';
    foreach ($pages as $page) {
        $selected = selected($footer_id, $page->ID, false);
        echo '<option value="' . esc_attr($page->ID) . '" ' . $selected . '>' . esc_html($page->post_title) . '</option>';
    }
    echo '</select>';
}

function skill_save_header_footer_metabox($post_id) {
    if (!isset($_POST['skill_header_footer_nonce']) || !wp_verify_nonce($_POST['skill_header_footer_nonce'], 'skill_header_footer_nonce')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    $post_type = get_post_type($post_id);
    if ($post_type === 'page') {
        if (!current_user_can('edit_page', $post_id)) {
            return;
        }
    } else {
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
    }

    if (isset($_POST['skill_custom_header'])) {
        update_post_meta($post_id, '_skill_custom_header', sanitize_text_field($_POST['skill_custom_header']));
    }

    if (isset($_POST['skill_custom_footer'])) {
        update_post_meta($post_id, '_skill_custom_footer', sanitize_text_field($_POST['skill_custom_footer']));
    }
}
add_action('save_post_page', 'skill_save_header_footer_metabox');
add_action('save_post_project', 'skill_save_header_footer_metabox');
add_action('save_post_post', 'skill_save_header_footer_metabox');

// Loading Elementor styles for projects and pages
add_action('wp_enqueue_scripts', 'skill_enqueue_elementor_styles', 999);
function skill_enqueue_elementor_styles() {
    if (is_page_template('home-landing.php') || is_singular('project')) {
        $header_id = get_post_meta(get_queried_object_id(), '_skill_custom_header', true);
        $footer_id = get_post_meta(get_queried_object_id(), '_skill_custom_footer', true);

        if ($header_id) {
            Elementor\Plugin::instance()->frontend->enqueue_styles();
            if (class_exists('\Elementor\Core\Files\CSS\Post')) {
                $css_file = new \Elementor\Core\Files\CSS\Post($header_id);
                $css_file->enqueue();
            }
        }

        if ($footer_id) {
            Elementor\Plugin::instance()->frontend->enqueue_styles();
            if (class_exists('\Elementor\Core\Files\CSS\Post')) {
                $css_file = new \Elementor\Core\Files\CSS\Post($footer_id);
                $css_file->enqueue();
            }
        }

        // Loading Elementor General Style
        if (class_exists('\Elementor\Plugin')) {
            \Elementor\Plugin::instance()->frontend->enqueue_styles();
        }
    }
}