<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php
if (function_exists('rank_math') && class_exists('RankMath\Paper\Paper')) {
    
    $rankmath_title = RankMath\Paper\Paper::get()->get_title();
    if (!empty($rankmath_title)) {
        echo esc_html($rankmath_title);
    } else {
        
        wp_title('');
    }
} else {
    
    if (is_front_page() || is_home()) {
        
        bloginfo('name');
        if (get_bloginfo('description')) {
            echo ' - ' . get_bloginfo('description');
        }
    } else {
        
        wp_title('');
        echo ' - ';
        bloginfo('name');
    }
}
?></title>
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/all.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/fonts/iranyekan.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/fonts/dana/dana.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/fonts/kalameh/fontiran.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/fonts/yekanbakh/fontiran.css">
    <link rel="icon" href="<?php bloginfo('template_url'); ?>/assets/images/icon.png">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/style.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/style.css">
    <?php wp_head(); ?>

</head>
<body class="bg-skill">

<!-- Hamburger Menu Button -->
<div class="hamburger-menu-btn d-xl-none">
    <div class="hamburger-icon">
        <span></span>
        <span></span>
        <span></span>
    </div>
</div>

<!-- Mobile Menu Overlay -->
<div class="mobile-menu-overlay">
    <div class="mobile-menu-container">
        <div class="mobile-menu-header">
            <div class="mobile-menu-close" data-action="close-menu">
                <span></span>
                <span></span>
            </div>
            <?php if (get_theme_mod('skill_hamburger_phone_display', true)) : ?>
            <div class="mobile-menu-phone-number">
                <a href="tel:<?php echo esc_attr(get_theme_mod('skill_hamburger_phone_number', '09380000000')); ?>">
                    <?php echo esc_html(get_theme_mod('skill_hamburger_phone_number', '09380000000')); ?>
                </a>
            </div>
            <?php endif; ?>
        </div>
        <div class="mobile-menu-content">
            <?php
            wp_nav_menu(array(
                'theme_location' => 'icon-menu',
                'container'      => false,
                'items_wrap'     => '<ul class="mobile-menu-list">%3$s</ul>',
                'walker'         => new Mobile_Menu_Walker(),
                'fallback_cb'    => false
            ));
            ?>
        </div>
    </div>
</div>

<!--    Start Nav Menu-->
<div class="menu h-100 d-flex justify-content-center d-none d-xl-flex">
    <?php
    wp_nav_menu(array(
        'theme_location' => 'icon-menu',
        'container'      => false,
        'items_wrap'     => '<ul class="icon-menu-list">%3$s</ul>',
        'walker'         => new Icon_Menu_Walker(),
        'fallback_cb'    => false
    ));
    ?>
</div>
<!--    End Nav Menu-->