<?php

foreach (glob(get_template_directory() . '/inc/*.php') as $file) {
    include_once $file;
}
include_once('elementor/skill-elementor.php');

require_once __DIR__.'/activatezhk/validate-locked.php';
//**************** load translation theme ****************//
function load_translation()
{
    load_theme_textdomain('skill', get_template_directory() . '/languages');
}

add_action('after_setup_theme', 'load_translation');
//**************** end load translation theme ****************//

//**************** welcome to active theme ****************//
add_action('after_switch_theme', 'custom_allert');
function custom_allert()
{
    echo "<h3 style='text-align: center; color: #464644'>" .
        esc_html__('از اینکه قالب مهارت رو فعال کردین ممنونم، از شما بابت حسن انتخابتون سپاسگذارم.', 'skill') .
        "</h3>";
}
//**************** end welcome to active theme ****************//

//**************** main menu ****************//
function register_custom_menu()
{
    register_nav_menus(
        array(
            'icon-menu' => __('منوی اصلی', 'skill')
        )
    );
}

add_action('init', 'register_custom_menu');

class Icon_Menu_Walker extends Walker_Nav_Menu {
    public function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        $target = get_post_meta($item->ID, '_menu_item_target', true);
        $icon = get_post_meta($item->ID, '_menu_item_icon', true);

        $classes = empty($item->classes) ? array() : (array)$item->classes;
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item));

        $active_class = (in_array('current-menu-item', $classes)) ? 'active' : '';

        $output .= '<li class="menu-item ' . $active_class . '" data-target="' . esc_attr($target) . '">';
        $output .= '<a href="' . esc_url($item->url) . '" class="menu-icon-link" data-title="' . esc_attr($item->title) . '">';

        if ($icon) {
            $output .= '<i class="' . esc_attr($icon) . '"></i>';
        }

        $output .= '</a></li>';
    }
}

class Mobile_Menu_Walker extends Walker_Nav_Menu {
    public function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        $target = get_post_meta($item->ID, '_menu_item_target', true);
        $icon = get_post_meta($item->ID, '_menu_item_icon', true);

        $classes = empty($item->classes) ? array() : (array)$item->classes;
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item));

        $active_class = (in_array('current-menu-item', $classes)) ? 'active' : '';

        $output .= '<li class="menu-item ' . $active_class . '" data-target="' . esc_attr($target) . '">';
        $output .= '<a href="' . esc_url($item->url) . '" class="mobile-menu-link" data-title="' . esc_attr($item->title) . '">';

        if ($icon) {
            $output .= '<i class="' . esc_attr($icon) . '"></i>';
        }
        
        $output .= '<span class="mobile-menu-text">' . esc_html($item->title) . '</span>';
        $output .= '</a></li>';
    }
}

add_action('wp_nav_menu_item_custom_fields', 'add_custom_menu_fields', 10, 4);

function add_custom_menu_fields($item_id, $item, $depth, $args) {
    $target = get_post_meta($item_id, '_menu_item_target', true);
    $icon = get_post_meta($item_id, '_menu_item_icon', true);
    ?>
    <div class="field-custom description description-wide">
        <h4><?php _e('تنظیمات سفارشی منو', 'skill'); ?></h4>


        <p class="field-icon description">
            <label for="edit-menu-item-icon-<?php echo $item_id; ?>">
                <?php _e('کلاس آیکون (مثال: fas fa-user)', 'skill'); ?><br/>
                <input type="text" id="edit-menu-item-icon-<?php echo $item_id; ?>"
                       class="widefat code edit-menu-item-icon"
                       name="menu-item-icon[<?php echo $item_id; ?>]"
                       value="<?php echo esc_attr($icon); ?>"/>
            </label>
        </p>
    </div>
    <?php
}

add_action('wp_update_nav_menu_item', 'save_custom_menu_fields', 10, 3);

function save_custom_menu_fields($menu_id, $menu_item_db_id, $args) {
    if (isset($_REQUEST['menu-item-target'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_menu_item_target', sanitize_text_field($_POST['menu-item-target'][$menu_item_db_id]));
    }

    if (isset($_REQUEST['menu-item-icon'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_menu_item_icon', sanitize_text_field($_POST['menu-item-icon'][$menu_item_db_id]));
    }
}

function enqueue_custom_scripts() {
    wp_enqueue_script(
        'custom-menu-tooltip',
        get_template_directory_uri() . '/assets/js/main.js',
        array('jquery'),
    );
    
    // Enqueue project gallery styles
    wp_enqueue_style(
        'skill-project-gallery',
        get_template_directory_uri() . '/assets/css/project-gallery.css',
        array(),
        '1.0.0'
    );
    
    // Enqueue project gallery JavaScript
    wp_enqueue_script(
        'skill-project-gallery',
        get_template_directory_uri() . '/assets/js/project-gallery.js',
        array('jquery'),
        '1.0.0',
        true
    );
    
    // Enqueue project timeline styles
    wp_enqueue_style(
        'skill-project-timeline',
        get_template_directory_uri() . '/assets/css/project-timeline.css',
        array(),
        '1.0.0'
    );
    
    // Enqueue panel pricing widget styles
    wp_enqueue_style(
        'skill-panel-pricing-widget',
        get_template_directory_uri() . '/assets/css/skill-panel-pricing-widget.css',
        array(),
        '1.0.0'
    );
	
	// Enqueue Kalameh font
    wp_enqueue_style(
        'skill-kalameh-font',
        get_template_directory_uri() . '/assets/fonts/kalameh/fontiran.css',
        array(),
        '1.0.0'
    );
    
    // Enqueue Yekan Bakh font
    wp_enqueue_style(
        'skill-yekanbakh-font',
        get_template_directory_uri() . '/assets/fonts/yekanbakh/fontiran.css',
        array(),
        '1.0.0'
    );
    
    // Enqueue Font Awesome - CRITICAL for icons
    wp_enqueue_style(
        'skill-fontawesome',
        get_template_directory_uri() . '/assets/css/all.css',
        array(),
        '6.7.2'
    );

    // Enqueue iran yekan font
    wp_enqueue_style(
        'skill-iranyekan-font',
        get_template_directory_uri() . '/assets/fonts/iranyekan.css',
        array(),
        '1.0.0'
    );

    // Enqueue dana font
    wp_enqueue_style(
        'skill-dana-font',
        get_template_directory_uri() . '/assets/fonts/dana/dana.css',
        array(),
        '1.0.0'
    );
    
    // Enqueue custom comments styles
    if (is_singular() && comments_open()) {
        wp_enqueue_style(
            'skill-comments-custom',
            get_template_directory_uri() . '/assets/css/custom-comments.css',
            array(),
            '1.0.0'
        );
    }
    
    // Enqueue project post type styles
    if (is_singular('project')) {
        wp_enqueue_style(
            'skill-project-custom',
            get_template_directory_uri() . '/assets/css/post-type-project.css',
            array(),
            '1.0.0'
        );
    }
    
    // Enqueue WooCommerce custom styles and scripts
    if (class_exists('WooCommerce')) {
        wp_enqueue_style(
            'skill-woocommerce-custom',
            get_template_directory_uri() . '/assets/css/woocommerce-custom.css',
            array(),
            '1.0.0'
        );
        
        // Ensure WooCommerce scripts are loaded for product gallery
        if (is_product()) {
            wp_enqueue_script('wc-single-product');
            wp_enqueue_script('wc-add-to-cart-variation');
            wp_enqueue_script('zoom');
            wp_enqueue_script('flexslider');
            
            // Load custom WooCommerce JavaScript
            wp_enqueue_script(
                'skill-woocommerce-custom',
                get_template_directory_uri() . '/assets/js/woocommerce-custom.js',
                array('jquery', 'wc-single-product'),
                '1.0.0',
                true
            );
        }
    }
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

// --- Skill Post Rating AJAX ---
add_action('wp_enqueue_scripts', function() {
    wp_enqueue_script('skill-main', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), null, true);
    wp_localize_script('skill-main', 'skill_rating_data', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('skill_post_rating'),
        'already_rated' => __('شما قبلاً به این مقاله رأی داده‌اید.', 'skill'),
    ));
});

add_action('wp_ajax_skill_post_rating', 'skill_handle_post_rating');
add_action('wp_ajax_nopriv_skill_post_rating', 'skill_handle_post_rating');
function skill_handle_post_rating() {
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'skill_post_rating')) {
        wp_send_json_error(['message' => __('درخواست نامعتبر است.', 'skill')]);
    }
    $post_id = intval($_POST['post_id']);
    $rating = intval($_POST['rating']);
    if ($rating < 1 || $rating > 5) {
        wp_send_json_error(['message' => __('امتیاز نامعتبر است.', 'skill')]);
    }
    
    $user_ip = $_SERVER['REMOTE_ADDR'];
    $voted_ips = get_post_meta($post_id, 'skill_post_rating_ips', true);
    if (!is_array($voted_ips)) $voted_ips = array();
    if (in_array($user_ip, $voted_ips)) {
        wp_send_json_error(['message' => __('شما قبلاً رأی داده‌اید.', 'skill')]);
    }
    
    $total = (int)get_post_meta($post_id, 'skill_post_rating', true);
    $count = (int)get_post_meta($post_id, 'skill_post_rating_count', true);
    $total += $rating;
    $count++;
    update_post_meta($post_id, 'skill_post_rating', $total);
    update_post_meta($post_id, 'skill_post_rating_count', $count);
    $voted_ips[] = $user_ip;
    update_post_meta($post_id, 'skill_post_rating_ips', $voted_ips);
    $average = round($total / $count, 2);
    
    $average = min($average, 5);
    wp_send_json_success([
        'message' => __('رأی شما ثبت شد. متشکریم!', 'skill'),
        'average_text' => sprintf(__('امتیاز: %s از 5', 'skill'), $average),
        'count_text' => sprintf(_n('%d رای', '%d رای', $count, 'skill'), $count),
        'average' => $average,
    ]);
}
//**************** end Font Enqueue ****************//

//**************** end main menu ****************//

//**************** add tumbnile ****************//
add_theme_support('post-thumbnails');

// Remove default image sizes for better control
function skill_remove_default_image_sizes() {
    remove_image_size('thumbnail');
    remove_image_size('medium');
    remove_image_size('medium_large');
    remove_image_size('large');
}
add_action('init', 'skill_remove_default_image_sizes');

// Add custom image sizes for projects
function skill_add_custom_image_sizes() {
    add_image_size('project-thumbnail', 800, 600, true);
    add_image_size('project-featured', 1200, 800, true);
    add_image_size('project-gallery', 600, 400, true);
}
add_action('after_setup_theme', 'skill_add_custom_image_sizes');

// Filter to use full size images for projects
function skill_project_featured_image_size($size, $post_id) {
    if (get_post_type($post_id) === 'project') {
        return 'full';
    }
    return $size;
}
add_filter('post_thumbnail_size', 'skill_project_featured_image_size', 10, 2);
//**************** end add tumbnile ****************//

//**************** Show cart contents / total Ajax ****************//
add_filter('woocommerce_add_to_cart_fragments', 'skill_add_to_cart_ajax');
function skill_add_to_cart_ajax($fragments)
{
    ob_start();
    ?>
    <span class="cart_count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
    <?php
    $fragments['.cart_count'] = ob_get_clean();
}
//**************** end Show cart contents / total Ajax ****************//

//**************** Persian Date Functions ****************//
/**
 * Convert Gregorian date to Persian date
 * @param string $format Date format
 * @param int $timestamp Unix timestamp
 * @return string Persian date
 */
function skill_persian_date($format = 'j F Y', $timestamp = '') {
    if (empty($timestamp)) {
        $timestamp = time();
    }
    return jdate($format, $timestamp, '', 'Asia/Tehran', 'fa');
}

/**
 * Get Persian date for post
 * @param string $format Date format
 * @param int $post_id Post ID
 * @return string Persian date
 */
function skill_get_persian_post_date($format = 'j F Y', $post_id = null) {
    if (!$post_id) {
        $post_id = get_the_ID();
    }
    $timestamp = get_the_time('U', $post_id);
    return skill_persian_date($format, $timestamp);
}

/**
 * Get Persian date for comment
 * @param string $format Date format
 * @param object $comment Comment object
 * @return string Persian date
 */
function skill_get_persian_comment_date($format = 'j F Y', $comment = null) {
    if (!$comment) {
        global $comment;
    }
    $timestamp = strtotime($comment->comment_date);
    return skill_persian_date($format, $timestamp);
}

/**
 * Filter WordPress date to Persian date
 * @param string $the_date Original date
 * @param string $format Date format
 * @param int $post_id Post ID
 * @return string Persian date
 */
function skill_filter_date_to_persian($the_date, $format = '', $post_id = null) {
    if (!skill_should_use_persian_date()) {
        return $the_date;
    }
    if (!$post_id) {
        $post_id = get_the_ID();
    }
    return skill_get_persian_post_date($format, $post_id);
}

// Apply Persian date filter
add_filter('get_the_date', 'skill_filter_date_to_persian', 10, 3);
add_filter('the_date', 'skill_filter_date_to_persian', 10, 3);

/**
 * Custom comment date filter
 */
function skill_comment_date_filter($date, $format, $comment) {
    if (!skill_should_use_persian_date()) {
        return $date;
    }
    return skill_get_persian_comment_date($format, $comment);
}
add_filter('get_comment_date', 'skill_comment_date_filter', 10, 3);

/**
 * Custom comment time filter
 */
function skill_comment_time_filter($time, $format, $comment) {
    if (!skill_should_use_persian_date()) {
        return $time;
    }
    $timestamp = strtotime($comment->comment_date);
    return jdate('H:i', $timestamp, '', 'Asia/Tehran', 'fa');
}
add_filter('get_comment_time', 'skill_comment_time_filter', 10, 3);

/**
 * Convert WordPress date format to Persian
 * @param string $format WordPress date format
 * @param int $timestamp Unix timestamp
 * @return string Persian date
 */
function skill_convert_date_format($format, $timestamp = '') {
    if (empty($timestamp)) {
        $timestamp = time();
    }
    
    // Convert WordPress date format to JDF format
    $jdf_format = str_replace(
        ['d', 'D', 'j', 'l', 'N', 'S', 'w', 'z', 'W', 'F', 'm', 'M', 'n', 't', 'L', 'o', 'Y', 'y', 'a', 'A', 'B', 'g', 'G', 'h', 'H', 'i', 's', 'u', 'e', 'I', 'O', 'P', 'T', 'Z', 'c', 'r', 'U'],
        ['d', 'D', 'j', 'l', 'N', 'S', 'w', 'z', 'W', 'mm', 'm', 'km', 'n', 't', 'L', 'o', 'Y', 'y', 'a', 'A', 'B', 'g', 'G', 'h', 'H', 'i', 's', 'u', 'e', 'I', 'O', 'P', 'T', 'Z', 'c', 'r', 'U'],
        $format
    );
    
    return jdate($jdf_format, $timestamp, '', 'Asia/Tehran', 'fa');
}

/**
 * Filter for WordPress date format
 */
function skill_date_format_filter($date, $format, $timestamp) {
    return skill_convert_date_format($format, $timestamp);
}
add_filter('date_i18n', 'skill_date_format_filter', 10, 3);

/**
 * Conditional Persian date functions
 */
function skill_should_use_persian_date() {
    // Respect user toggle first
    $enabledInCustomizer = get_theme_mod('skill_enable_persian_date', true);
    if (!$enabledInCustomizer) {
        return false;
    }

    // If WPML is active, only enable Persian date for Persian language
    if (function_exists('wpml_get_current_language')) {
        $currentLang = wpml_get_current_language();
        return (is_string($currentLang) && strpos($currentLang, 'fa') === 0);
    }

    // Fallback: enable only when site locale is Persian
    return skill_is_default_locale();
}

/**
 * Modified Persian date functions with conditional check
 */
function skill_get_persian_post_date_conditional($format = 'j F Y', $post_id = null) {
    if (!skill_should_use_persian_date()) {
        return get_the_date($format, $post_id);
    }
    return skill_get_persian_post_date($format, $post_id);
}

function skill_get_persian_comment_date_conditional($format = 'j F Y', $comment = null) {
    if (!skill_should_use_persian_date()) {
        return get_comment_date($format, $comment);
    }
    return skill_get_persian_comment_date($format, $comment);
}

//**************** end Persian Date Functions ****************//

//**************** Admin IranYekan Font ****************//
function skill_admin_enqueue_iranyekan_font() {
    echo '<style>@font-face {
        font-family: iranyekan;
        font-style: normal;
        font-weight: normal;
        src: url("' . get_template_directory_uri() . '/assets/fonts/woff/iranyekanwebregularfanum.woff") format("woff");
    }
    body, .wp-core-ui, .editor-styles-wrapper, .edit-post-visual-editor, .block-editor-writing-flow, .block-editor-block-list__layout, .components-base-control__field, .components-button, .components-panel__body, .components-panel__row, .components-input-control__container, .components-input-control__input, .components-input-control__label, .components-input-control__suffix, .components-input-control__prefix, .components-input-control__help, .components-input-control__description, .components-input-control__error, .components-input-control__icon, .components-input-control__icon-container, .components-input-control__icon-svg, .components-input-control__icon-svg--left, .components-input-control__icon-svg--right, .components-input-control__icon-svg--top, .components-input-control__icon-svg--bottom, .components-input-control__icon-svg--center, .components-input-control__icon-svg--middle, .components-input-control__icon-svg--end, .components-input-control__icon-svg--start, .components-input-control__icon-svg--stretch, .components-input-control__icon-svg--shrink, .components-input-control__icon-svg--grow, .components-input-control__icon-svg--shrink-0, .components-input-control__icon-svg--grow-0, .components-input-control__icon-svg--shrink-1, .components-input-control__icon-svg--grow-1, .components-input-control__icon-svg--shrink-2, .components-input-control__icon-svg--grow-2, .components-input-control__icon-svg--shrink-3, .components-input-control__icon-svg--grow-3, .components-input-control__icon-svg--shrink-4, .components-input-control__icon-svg--grow-4, .components-input-control__icon-svg--shrink-5, .components-input-control__icon-svg--grow-5 {
        font-family: iranyekan, Tahoma, Arial, sans-serif !important;
    }</style>';
}
add_action('admin_head', 'skill_admin_enqueue_iranyekan_font');
//**************** End Admin IranYekan Font ****************//

//**************** Customizer IranYekan Font ****************//
// Apply IranYekan font to Appearance > Customize controls
function skill_customizer_enqueue_iranyekan_font() {
    $font_url = get_template_directory_uri() . '/assets/fonts/woff/iranyekanwebregularfanum.woff';
    echo '<style>
    @font-face {
        font-family: iranyekan;
        font-style: normal;
        font-weight: normal;
        src: url("' . esc_url($font_url) . '") format("woff");
        font-display: swap;
    }
    #customize-controls,
    .wp-full-overlay-sidebar,
    .customize-controls-container,
    .customize-pane-parent,
    .customize-section-title,
    .customize-panel-description,
    .customize-section-description,
    .customize-control,
    .customize-control-title,
    .customize-control-description,
    .customize-control input,
    .customize-control textarea,
    .customize-control select,
    .customize-controls-close,
    .customize-actions .button,
    .wp-core-ui,
    .components-base-control,
    .components-button,
    .components-input-control__container,
    .components-input-control__input,
    .components-select-control,
    .components-text-control__input,
    .components-panel__body,
    .accordion-section-title {
        font-family: iranyekan, Tahoma, Arial, sans-serif !important;
    }
    </style>';
}
add_action('customize_controls_print_styles', 'skill_customizer_enqueue_iranyekan_font');
//**************** End Customizer IranYekan Font ****************//

//**************** Category Archive Blog ****************//
add_action('pre_get_posts', 'skill_filter_blog_archive_by_category');
function skill_filter_blog_archive_by_category($query) {
    if (
        $query->is_main_query() &&
        !is_admin() &&
        (is_home() || is_archive())
    ) {
        $enable_category_filter = get_theme_mod('skill_blog_archive_enable_category_filter', false);
        if ($enable_category_filter) {
            $categories = get_categories(array(
                'hide_empty' => false,
                'orderby' => 'name',
                'order' => 'ASC'
            ));
            $selected_categories = array();
            foreach ($categories as $category) {
                if (get_theme_mod('skill_blog_archive_category_' . $category->term_id, false)) {
                    $selected_categories[] = $category->term_id;
                }
            }
            if (!empty($selected_categories)) {
                $query->set('category__in', $selected_categories);
            }
            
            $posts_per_page = get_theme_mod('skill_blog_archive_posts_per_page', get_option('posts_per_page'));
            $query->set('posts_per_page', $posts_per_page);
        }
    }
}
//**************** End Category Archive Blog ****************//

//**************** Yekan Bakh Font Test Functions ****************//
// Add test functions for Yekan Bakh font verification
add_action('wp_enqueue_scripts', 'test_yekanbakh_elementor_fonts');

function test_yekanbakh_elementor_fonts() {
    // Only load on a specific test page
    if (is_page('font-test')) {
        wp_enqueue_style('yekanbakh-test', get_template_directory_uri() . '/assets/fonts/yekanbakh/fontiran.css');
        
        // Add test CSS
        wp_add_inline_style('yekanbakh-test', '
            /* Test styles for Yekan Bakh font */
            .font-test-container {
                padding: 20px;
                margin: 20px;
                border: 2px solid #ccc;
                background: #f9f9f9;
            }
            
            .font-test-container h1,
            .font-test-container h2,
            .font-test-container h3,
            .font-test-container h4,
            .font-test-container h5,
            .font-test-container h6 {
                font-family: "Yekan Bakh FaNum", tahoma, sans-serif !important;
                color: #333;
                margin: 10px 0;
            }
            
            .font-test-container p {
                font-family: "Yekan Bakh FaNum", tahoma, sans-serif !important;
                color: #666;
                line-height: 1.6;
            }
            
            .elementor-test h1,
            .elementor-test h2,
            .elementor-test h3,
            .elementor-test h4,
            .elementor-test h5,
            .elementor-test h6 {
                font-family: "Yekan Bakh FaNum", tahoma, sans-serif !important;
                color: #e74c3c;
                border-left: 4px solid #e74c3c;
                padding-left: 10px;
            }
        ');
    }
}

// Add a shortcode to display test content
add_shortcode('yekanbakh_test', 'yekanbakh_test_shortcode');

function yekanbakh_test_shortcode($atts) {
    $output = '<div class="font-test-container">';
    $output .= '<h1>عنوان H1 - Yekan Bakh Font Test</h1>';
    $output .= '<h2>عنوان H2 - Yekan Bakh Font Test</h2>';
    $output .= '<h3>عنوان H3 - Yekan Bakh Font Test</h3>';
    $output .= '<h4>عنوان H4 - Yekan Bakh Font Test</h4>';
    $output .= '<h5>عنوان H5 - Yekan Bakh Font Test</h5>';
    $output .= '<h6>عنوان H6 - Yekan Bakh Font Test</h6>';
    $output .= '<p>این یک متن نمونه برای تست فونت یکان بخ است. متن شامل حروف فارسی و انگلیسی می‌باشد.</p>';
    $output .= '<p>This is a sample text for testing Yekan Bakh font. The text includes Persian and English characters.</p>';
    $output .= '</div>';
    
    $output .= '<div class="elementor-test">';
    $output .= '<h1>Elementor H1 - Yekan Bakh Font Test</h1>';
    $output .= '<h2>Elementor H2 - Yekan Bakh Font Test</h2>';
    $output .= '<h3>Elementor H3 - Yekan Bakh Font Test</h3>';
    $output .= '<h4>Elementor H4 - Yekan Bakh Font Test</h4>';
    $output .= '<h5>Elementor H5 - Yekan Bakh Font Test</h5>';
    $output .= '<h6>Elementor H6 - Yekan Bakh Font Test</h6>';
    $output .= '</div>';
    
    return $output;
}
//**************** End Yekan Bakh Font Test Functions ****************//

//**************** Story Like System ****************//
// Add AJAX handlers for story likes
add_action('wp_ajax_skill_story_like', 'skill_handle_story_like');
add_action('wp_ajax_nopriv_skill_story_like', 'skill_handle_story_like');

function skill_handle_story_like() {
    // Verify nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'skill_story_like')) {
        wp_send_json_error(['message' => __('درخواست نامعتبر است.', 'skill')]);
    }
    
    $story_key = sanitize_text_field($_POST['story_key']);
    $item_index = intval($_POST['item_index']);
    $action = sanitize_text_field($_POST['action_type']); // 'like' or 'unlike'
    
    if (empty($story_key) || $item_index < 0) {
        wp_send_json_error(['message' => __('اطلاعات نامعتبر است.', 'skill')]);
    }
    
    // Get user IP for tracking
    $user_ip = $_SERVER['REMOTE_ADDR'];
    
    // Create unique key for this story item
    $like_key = 'skill_story_likes_' . md5($story_key . '_' . $item_index);
    $user_key = 'skill_story_users_' . md5($story_key . '_' . $item_index);
    
    // Get current likes and users
    $current_likes = get_option($like_key, 0);
    $liked_users = get_option($user_key, array());
    
    if (!is_array($liked_users)) {
        $liked_users = array();
    }
    
    if ($action === 'get_data') {
        // Just return current data without making changes
        $user_has_liked = in_array($user_ip, $liked_users);
        
        wp_send_json_success([
            'likes_count' => $current_likes,
            'user_has_liked' => $user_has_liked,
        ]);
        return;
        
    } elseif ($action === 'like') {
        // Check if user already liked
        if (in_array($user_ip, $liked_users)) {
            wp_send_json_error(['message' => __('شما قبلاً این استوری را لایک کرده‌اید.', 'skill')]);
        }
        
        // Add like
        $current_likes++;
        $liked_users[] = $user_ip;
        
    } elseif ($action === 'unlike') {
        // Check if user has liked
        if (!in_array($user_ip, $liked_users)) {
            wp_send_json_error(['message' => __('شما این استوری را لایک نکرده‌اید.', 'skill')]);
        }
        
        // Remove like
        $current_likes = max(0, $current_likes - 1);
        $liked_users = array_diff($liked_users, array($user_ip));
        
    } else {
        wp_send_json_error(['message' => __('عملیات نامعتبر است.', 'skill')]);
    }
    
    // Save updated data
    update_option($like_key, $current_likes);
    update_option($user_key, $liked_users);
    
    // Check if user has liked this item
    $user_has_liked = in_array($user_ip, $liked_users);
    
    wp_send_json_success([
        'likes_count' => $current_likes,
        'user_has_liked' => $user_has_liked,
        'message' => $action === 'like' ? __('لایک شما ثبت شد!', 'skill') : __('لایک شما حذف شد.', 'skill')
    ]);
}

// Add AJAX script localization for story likes
add_action('wp_enqueue_scripts', function() {
    wp_localize_script('skill-main', 'skill_story_like_data', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('skill_story_like'),
    ));
});
//**************** End Story Like System ****************//

//**************** WPML Support ****************//
// Add WPML support for theme
function skill_wpml_support() {
    // Add theme support for WPML
    add_theme_support('wpml');
    
    // Register strings for translation
    if (function_exists('icl_register_string')) {
        // Register theme strings
        icl_register_string('skill', 'Theme Name', 'Skill');
        icl_register_string('skill', 'Theme Description', 'قالب Skill با نام فارسی مهارت، یک قالب شخصی و رزومه کاملا ایرانی است');
    }
}
add_action('after_setup_theme', 'skill_wpml_support');

// WPML Language Switcher - Real WPML Integration
function skill_wpml_language_switcher() {
    // Only show if WPML is active
    if (!function_exists('icl_get_languages') && !function_exists('apply_filters')) {
        return;
    }
    
    // Prefer WPML filter API for better coverage
    if (function_exists('apply_filters')) {
        $languages = apply_filters('wpml_active_languages', null, array('skip_missing' => 0, 'orderby' => 'code'));
        if (empty($languages)) {
            // Fallback: allow missing URLs (we'll build them)
            $languages = apply_filters('wpml_active_languages', null, array('skip_missing' => 1, 'orderby' => 'code'));
        }
    }
    if (!isset($languages) || !is_array($languages) || empty($languages)) {
        $languages = function_exists('icl_get_languages') ? icl_get_languages('skip_missing=0&orderby=code') : array();
        if (empty($languages) && function_exists('icl_get_languages')) {
            $languages = icl_get_languages('skip_missing=1&orderby=code');
        }
    }
    if (empty($languages)) {
        return;
    }
    
    echo '<div class="skill-wpml-language-switcher">';
    echo '<div class="language-switcher-container">';
    
    foreach ($languages as $lang) {
        $class = $lang['active'] ? 'active' : '';
        $flag = !empty($lang['country_flag_url']) ? $lang['country_flag_url'] : '';
        $native_name = $lang['native_name'];
        $code = $lang['code'];
        // Robust URL: use provided URL; if missing, try wpml_permalink; then home URL
        $target_url = isset($lang['url']) ? $lang['url'] : '';
        if (empty($target_url) && function_exists('apply_filters')) {
            $current_url = get_permalink();
            if ($current_url) {
                $translated = apply_filters('wpml_permalink', $current_url, $code, true);
                if (!empty($translated)) {
                    $target_url = $translated;
                }
            }
            if (empty($target_url)) {
                $home_url = apply_filters('wpml_home_url', home_url('/'), $code);
                if (!empty($home_url)) {
                    $target_url = $home_url;
                }
            }
        }
        if (empty($target_url)) {
            $target_url = home_url('/');
        }
        
        echo '<a href="' . esc_url($target_url) . '" class="lang-link ' . $class . '" title="' . esc_attr($native_name) . '">';
        
        if ($flag) {
            echo '<img src="' . esc_url($flag) . '" alt="' . esc_attr($native_name) . '" class="flag-icon">';
        }
        
        echo '<span class="lang-code">' . esc_html(strtoupper($code)) . '</span>';
        echo '</a>';
    }
    
    echo '</div>';
    echo '</div>';
}

// WPML Menu Support
function skill_wpml_menu_args($args) {
    if (function_exists('wpml_object_id_filter')) {
        $args['theme_location'] = $args['theme_location'];
    }
    return $args;
}
add_filter('wp_nav_menu_args', 'skill_wpml_menu_args');

// WPML Custom Post Type Support
function skill_wpml_custom_post_types() {
    if (function_exists('wpml_register_single_string')) {
        // Register project post type strings
        wpml_register_single_string('skill', 'Project Title', 'Project Title');
        wpml_register_single_string('skill', 'Project Description', 'Project Description');
    }
}
add_action('init', 'skill_wpml_custom_post_types');

// WPML Elementor Widget Support
function skill_wpml_elementor_widgets($widgets_manager) {
    // This will be handled by WPML's Elementor integration
    if (function_exists('wpml_elementor_widgets')) {
        wpml_elementor_widgets($widgets_manager);
    }
}
add_action('elementor/widgets/register', 'skill_wpml_elementor_widgets');

// WPML RTL Support
function skill_wpml_rtl_support() {
    if (function_exists('wpml_get_current_language')) {
        $current_lang = wpml_get_current_language();
        $rtl_languages = array('ar', 'he', 'fa', 'ur');
        
        if (in_array($current_lang, $rtl_languages)) {
            add_filter('body_class', function($classes) {
                $classes[] = 'rtl';
                return $classes;
            });
        }
    }
}
add_action('wp_head', 'skill_wpml_rtl_support');

// WPML Custom Fields Support
function skill_wpml_custom_fields() {
    if (function_exists('wpml_register_single_string')) {
        // Register custom fields for translation
        $custom_fields = array(
            'skill_birth_date',
            'skill_location', 
            'skill_cooperation',
            'skill_expertise',
            'skill_phone',
            'skill_email'
        );
        
        foreach ($custom_fields as $field) {
            wpml_register_single_string('skill', $field, $field);
        }
    }
}
add_action('init', 'skill_wpml_custom_fields');

// Add Language Switcher to bottom left - Only if WPML is active
function skill_add_language_switcher_bottom_left() {
    // Only show if WPML is active and has languages
    if (!function_exists('icl_get_languages') && !function_exists('apply_filters')) {
        return;
    }
    
    // Prefer WPML filter API for better coverage
    if (function_exists('apply_filters')) {
        $languages = apply_filters('wpml_active_languages', null, array('skip_missing' => 0, 'orderby' => 'code'));
        if (empty($languages)) {
            // Fallback: allow missing URLs (we'll build them)
            $languages = apply_filters('wpml_active_languages', null, array('skip_missing' => 1, 'orderby' => 'code'));
        }
    }
    if (!isset($languages) || !is_array($languages) || empty($languages)) {
        $languages = function_exists('icl_get_languages') ? icl_get_languages('skip_missing=0&orderby=code') : array();
        if (empty($languages) && function_exists('icl_get_languages')) {
            $languages = icl_get_languages('skip_missing=1&orderby=code');
        }
    }
    if (empty($languages)) {
        return;
    }
    
    echo '<div class="skill-wpml-language-switcher-bottom">';
    echo '<div class="language-switcher-container">';
    
    foreach ($languages as $lang) {
        $class = $lang['active'] ? 'active' : '';
        $flag = !empty($lang['country_flag_url']) ? $lang['country_flag_url'] : '';
        $native_name = $lang['native_name'];
        $code = $lang['code'];
        // Robust URL per language
        $target_url = isset($lang['url']) ? $lang['url'] : '';
        if (empty($target_url) && function_exists('apply_filters')) {
            $current_url = get_permalink();
            if ($current_url) {
                $translated = apply_filters('wpml_permalink', $current_url, $code, true);
                if (!empty($translated)) {
                    $target_url = $translated;
                }
            }
            if (empty($target_url)) {
                $home_url = apply_filters('wpml_home_url', home_url('/'), $code);
                if (!empty($home_url)) {
                    $target_url = $home_url;
                }
            }
        }
        if (empty($target_url)) {
            $target_url = home_url('/');
        }
        
        echo '<a href="' . esc_url($target_url) . '" class="lang-link ' . $class . '" title="' . esc_attr($native_name) . '">';
        
        if ($flag) {
            echo '<img src="' . esc_url($flag) . '" alt="' . esc_attr($native_name) . '" class="flag-icon">';
        }
        
        echo '<span class="lang-code">' . esc_html(strtoupper($code)) . '</span>';
        echo '</a>';
    }
    
    echo '</div>';
    echo '</div>';
}
add_action('wp_footer', 'skill_add_language_switcher_bottom_left');

//**************** end WPML Support ****************//

//**************** Locale helpers for footer translations via .po/.mo ****************//
function skill_is_default_locale() {
    // Treat fa (and fa_IR) as default Persian locale
    $locale = function_exists('get_locale') ? get_locale() : 'fa_IR';
    return ($locale === 'fa_IR' || strpos($locale, 'fa') === 0);
}

function skill_footer_text($default_key, $default_text) {
    // Always use Customizer value so WPML (admin_texts) can localize per language
    return get_theme_mod($default_key, $default_text);
}
//**************** End locale helpers ****************//

//**************** WPML admin_texts helper for footer keys ****************//
if (!function_exists('skill_wpml_admin_text')) {
function skill_wpml_admin_text($key, $fallback_value) {
    // Ensure we have a plain value
    $value = $fallback_value;

    // No WPML available
    if (!function_exists('icl_t')) {
        return $value;
    }

    // Try the common admin texts domains and key formats used by WPML
    $candidates = array(
        array('domain' => 'admin_texts_theme_mods_skill', 'name' => $key),
        // Some sites keep the serialized admin option format as the name
        array('domain' => 'admin_texts_theme_mods_skill', 'name' => 'theme_mods_skill[' . $key . ']'),
        // Rare: domain appended with key
        array('domain' => 'admin_texts_theme_mods_skill:' . $key, 'name' => $key),
        // Legacy generic domain sometimes seen
        array('domain' => 'admin_texts', 'name' => 'theme_mods_skill[' . $key . ']'),
    );

    // Best-effort registration so strings appear in String Translation
    if (function_exists('icl_register_string')) {
        foreach ($candidates as $cand) {
            icl_register_string($cand['domain'], $cand['name'], $value);
        }
    }

    // Try fetch in order
    foreach ($candidates as $cand) {
        $translated = icl_t($cand['domain'], $cand['name'], $value);
        if (is_string($translated) && $translated !== '' && $translated !== $value) {
            return $translated;
        }
    }

    return $value;
}
}
//**************** End WPML admin_texts helper ****************//