<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;

class skill_top_button_Widget extends Widget_Base {
    public function get_name() {
        return 'skill_top_button';
    }
    public function get_title() {
        return __( 'دکمه بازگشت به بالا با پروگرس', 'skill' );
    }
    public function get_icon() {
        return 'eicon-scroll';
    }
    public function get_categories() {
        return [ 'skill-category' ];
    }
    public function get_keywords() {
        return [ 'top', 'scroll', 'back to top', 'progress', 'skill' ];
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'محتوا', 'skill' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __( 'آیکون', 'skill' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-up',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $this->add_control(
            'show_on_mobile',
            [
                'label' => __( 'نمایش در موبایل', 'skill' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_on_desktop',
            [
                'label' => __( 'نمایش در دسکتاپ', 'skill' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'استایل دکمه', 'skill' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'button_size',
            [
                'label' => __( 'اندازه دکمه (px)', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 32, 'max' => 120 ],
                ],
                'default' => [ 'size' => 56 ],
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label' => __( 'اندازه آیکون (px)', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 12, 'max' => 64 ],
                ],
                'default' => [ 'size' => 24 ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه دکمه', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => __( 'رنگ آیکون', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#222222',
            ]
        );
        $this->add_control(
            'progress_color',
            [
                'label' => __( 'رنگ پروگرس (بردر)', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#007aff',
            ]
        );
        $this->add_control(
            'progress_bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه پروگرس', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#e5e5e5',
            ]
        );
        $this->add_control(
            'progress_thickness',
            [
                'label' => __( 'ضخامت پروگرس (px)', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 2, 'max' => 16 ],
                ],
                'default' => [ 'size' => 4 ],
            ]
        );
        $this->add_control(
            'box_shadow',
            [
                'label' => __( 'سایه دکمه', 'skill' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'position_bottom',
            [
                'label' => __( 'فاصله از پایین (px)', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [ 'px' => [ 'min' => 0, 'max' => 100 ] ],
                'default' => [ 'size' => 32 ],
            ]
        );
        $this->add_control(
            'position_right',
            [
                'label' => __( 'فاصله از راست (px)', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [ 'px' => [ 'min' => 0, 'max' => 100 ] ],
                'default' => [ 'size' => 32 ],
            ]
        );
        $this->add_control(
            'scroll_speed',
            [
                'label' => __( 'سرعت اسکرول نرم (ms)', 'skill' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 600,
                'min' => 100,
                'max' => 3000,
            ]
        );
        $this->end_controls_section();
    }

    public function get_style_depends() {
        return [ 'font-awesome' ];
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $id = 'skill-top-btn-' . $this->get_id();
        $size = !empty($settings['button_size']['size']) ? $settings['button_size']['size'] : 56;
        $icon_size = !empty($settings['icon_size']['size']) ? $settings['icon_size']['size'] : 24;
        $progress_thickness = !empty($settings['progress_thickness']['size']) ? $settings['progress_thickness']['size'] : 4;
        $radius = ($size / 2) - ($progress_thickness / 2);
        $circumference = 2 * pi() * $radius;
        $show_on_mobile = $settings['show_on_mobile'] === 'yes';
        $show_on_desktop = $settings['show_on_desktop'] === 'yes';
        ?>
        <div id="<?php echo esc_attr($id); ?>" class="skill-top-btn-wrap" style="position:fixed;z-index:9999;bottom:<?php echo esc_attr($settings['position_bottom']['size']); ?>px;right:<?php echo esc_attr($settings['position_right']['size']); ?>px;<?php if(!$show_on_mobile): ?>display:none;@media(min-width:768px){display:block;}<?php endif; ?><?php if(!$show_on_desktop): ?>@media(min-width:768px){display:none;}<?php endif; ?>">
            <button class="skill-top-btn" type="button" aria-label="<?php esc_attr_e('بازگشت به بالا','skill'); ?>" style="width:<?php echo esc_attr($size); ?>px;height:<?php echo esc_attr($size); ?>px;background:<?php echo esc_attr($settings['button_bg_color']); ?>;border:none;border-radius:50%;position:relative;display:flex;align-items:center;justify-content:center;<?php if($settings['box_shadow']==='yes'){echo 'box-shadow:0 4px 16px rgba(0,0,0,0.15);';} ?>cursor:pointer;">
                <svg class="skill-top-btn-progress" width="<?php echo esc_attr($size); ?>" height="<?php echo esc_attr($size); ?>" style="position:absolute;top:0;left:0;transform:rotate(-90deg);pointer-events:none;" >
                    <circle cx="<?php echo $size/2; ?>" cy="<?php echo $size/2; ?>" r="<?php echo $radius; ?>" stroke="<?php echo esc_attr($settings['progress_bg_color']); ?>" stroke-width="<?php echo $progress_thickness; ?>" fill="none" />
                    <circle class="skill-top-btn-progress-bar" cx="<?php echo $size/2; ?>" cy="<?php echo $size/2; ?>" r="<?php echo $radius; ?>" stroke="<?php echo esc_attr($settings['progress_color']); ?>" stroke-width="<?php echo $progress_thickness; ?>" fill="none" stroke-linecap="round" stroke-dasharray="<?php echo $circumference; ?>" stroke-dashoffset="<?php echo $circumference; ?>" />
                </svg>
                <span class="skill-top-btn-icon" style="font-size:<?php echo esc_attr($icon_size); ?>px;color:<?php echo esc_attr($settings['icon_color']); ?>;z-index:1;">
                    <?php
                    // Render as <i> tag if Font Awesome, otherwise fallback to SVG
                    if (!empty($settings['icon']['library']) && strpos($settings['icon']['library'], 'fa') !== false && !empty($settings['icon']['value'])) {
                        echo '<i class="' . esc_attr($settings['icon']['value']) . '"></i>';
                    } else {
                        \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );
                    }
                    ?>
                </span>
            </button>
        </div>
        <style>
        #<?php echo esc_attr($id); ?> {transition:opacity 0.3s;}
        #<?php echo esc_attr($id); ?>.is-hidden {opacity:0;pointer-events:none;}
        #<?php echo esc_attr($id); ?> .skill-top-btn {
            transition: transform 0.25s cubic-bezier(0.4,0,0.2,1), box-shadow 0.25s;
        }
        #<?php echo esc_attr($id); ?> .skill-top-btn:hover {
            transform: translateY(-8px);
        }
        @media (max-width: 767px) {
            #<?php echo esc_attr($id); ?> {<?php if(!$show_on_mobile): ?>display:none !important;<?php endif; ?>}
        }
        @media (min-width: 768px) {
            #<?php echo esc_attr($id); ?> {<?php if(!$show_on_desktop): ?>display:none !important;<?php endif; ?>}
        }
        </style>
        <script>
        (function(){
            var btn = document.getElementById('<?php echo esc_js($id); ?>');
            if(!btn) return;
            var progress = btn.querySelector('.skill-top-btn-progress-bar');
            var scrollBtn = btn.querySelector('.skill-top-btn');
            var circumference = <?php echo $circumference; ?>;
            var scrollSpeed = <?php echo intval($settings['scroll_speed']); ?>;
            function setProgress() {
                var scrollTop = window.scrollY || document.documentElement.scrollTop;
                var docHeight = document.documentElement.scrollHeight - window.innerHeight;
                var percent = docHeight > 0 ? scrollTop / docHeight : 0;
                var offset = circumference - (percent * circumference);
                progress.style.strokeDashoffset = offset;
            }
            function toggleBtn() {
                if(window.scrollY > 100) {
                    btn.classList.remove('is-hidden');
                } else {
                    btn.classList.add('is-hidden');
                }
            }
            setProgress();
            toggleBtn();
            window.addEventListener('scroll', function(){
                setProgress();
                toggleBtn();
            });
            scrollBtn.addEventListener('click', function(e){
                e.preventDefault();
                var start = window.scrollY || document.documentElement.scrollTop;
                var startTime = null;
                function scrollStep(timestamp) {
                    if (!startTime) startTime = timestamp;
                    var progress = timestamp - startTime;
                    var percent = Math.min(progress / scrollSpeed, 1);
                    window.scrollTo(0, start * (1 - percent));
                    if (percent < 1) {
                        window.requestAnimationFrame(scrollStep);
                    }
                }
                window.requestAnimationFrame(scrollStep);
            });
        })();
        </script>
        <?php
    }
}
