<?php

class Skill_Tools_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_tools_widget';
    }

    public function get_title() {
        return esc_html__('ابزارهای مهارت', 'skill');
    }

    public function get_icon() {
        return 'eicon-tools';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {
        // General title of the widget
        $this->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('عنوان کلی', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('عنوان ویجت', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('ابزارهای مهارت من', 'skill'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'main_title_color',
            [
                'label' => esc_html__('رنگ عنوان ویجت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-tools-main-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'main_title_size',
            [
                'label' => esc_html__('سایز عنوان ویجت', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [ 'min' => 12, 'max' => 48, 'step' => 1 ],
                    'em' => [ 'min' => 0.5, 'max' => 3, 'step' => 0.01 ],
                    'rem' => [ 'min' => 0.5, 'max' => 3, 'step' => 0.01 ],
                ],
                'default' => [ 'unit' => 'px', 'size' => 22 ],
                'selectors' => [
                    '{{WRAPPER}} .skill-tools-main-title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'main_title_margin',
            [
                'label' => esc_html__('فاصله عنوان از ابزارها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [ 'min' => 0, 'max' => 100, 'step' => 1 ],
                    'em' => [ 'min' => 0, 'max' => 6, 'step' => 0.01 ],
                    'rem' => [ 'min' => 0, 'max' => 6, 'step' => 0.01 ],
                ],
                'default' => [ 'unit' => 'px', 'size' => 24 ],
                'selectors' => [
                    '{{WRAPPER}} .skill-tools-main-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'main_title_typography',
                'label' => esc_html__('تایپوگرافی عنوان ویجت', 'skill'),
                'selector' => '{{WRAPPER}} .skill-tools-main-title',
            ]
        );
        $this->end_controls_section();

        // List of tools
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('ابزارها', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tool_image',
            [
                'label' => esc_html__('تصویر ابزار', 'skill'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'tool_title',
            [
                'label' => esc_html__('عنوان ابزار', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('عنوان ابزار', 'skill'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tool_desc',
            [
                'label' => esc_html__('توضیح ابزار', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('توضیح کوتاه ابزار', 'skill'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tool_link',
            [
                'label' => esc_html__('لینک ابزار', 'skill'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
            'tools_list',
            [
                'label' => esc_html__('لیست ابزارها', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tool_title' => esc_html__('نمونه ابزار', 'skill'),
                        'tool_desc' => esc_html__('توضیح کوتاه ابزار', 'skill'),
                        'tool_image' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                        'tool_link' => [
                            'url' => '',
                        ],
                    ],
                ],
                'title_field' => '{{{ tool_title }}}',
            ]
        );

        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل آیتم ابزار', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_width',
            [
                'label' => esc_html__('عرض هر آیتم', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 600,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 210,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-tool-item' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_height',
            [
                'label' => esc_html__('ارتفاع هر آیتم', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 60,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 70,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-tool-item' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_size',
            [
                'label' => esc_html__('اندازه تصویر', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 32,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 48,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-tool-img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('رنگ پس‌زمینه آیتم', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#151415',
                'selectors' => [
                    '{{WRAPPER}} .skill-tool-item' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'item_border_color',
            [
                'label' => esc_html__('رنگ بردر آیتم', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .skill-tool-item' => 'border:1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => esc_html__('گردی گوشه آیتم', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 32,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-tool-item' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان ابزار', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-tool-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('رنگ توضیح ابزار', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-tool-desc' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('تایپوگرافی عنوان ابزار', 'skill'),
                'selector' => '{{WRAPPER}} .skill-tool-title',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'label' => esc_html__('تایپوگرافی توضیح ابزار', 'skill'),
                'selector' => '{{WRAPPER}} .skill-tool-desc',
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if (empty($settings['tools_list'])) return;
        // General title
        if (!empty($settings['main_title'])) {
            echo '<div class="skill-tools-main-title" style="width:100%;">' . esc_html($settings['main_title']) . '</div>';
        }
        echo '<div class="skill-tools-list" style="display:flex;flex-direction:row;align-items:flex-start;justify-content:center;gap:20px;width:100%;flex-wrap:wrap;">';
        foreach ($settings['tools_list'] as $item) {
            $img_url = isset($item['tool_image']['url']) ? $item['tool_image']['url'] : '';
            $title = isset($item['tool_title']) ? $item['tool_title'] : '';
            $desc = isset($item['tool_desc']) ? $item['tool_desc'] : '';
            $link = isset($item['tool_link']['url']) ? $item['tool_link']['url'] : '';
            $is_external = !empty($item['tool_link']['is_external']) ? ' target="_blank"' : '';
            $nofollow = !empty($item['tool_link']['nofollow']) ? ' rel="nofollow"' : '';
            echo '<div class="skill-tool-item">';
            // Vertical and right middle image
            echo '<span class="skill-tool-img-wrap" style="display:flex;align-items:center;justify-content:center;min-width:56px;min-height:56px;">';
            if ($link) {
                echo '<a href="' . esc_url($link) . '" class="skill-tool-img-link"' . $is_external . $nofollow . ' style="display:inline-block;">';
            }
            echo '<img src="' . esc_url($img_url) . '" alt="' . esc_attr($title) . '" class="skill-tool-img">';
            if ($link) {
                echo '</a>';
            }
            echo '</span>';
            // Left text
            echo '<div style="flex:1;text-align:right;padding-right:16px;">';
            echo '<div class="skill-tool-title">' . esc_html($title) . '</div>';
            echo '<div class="skill-tool-desc">' . esc_html($desc) . '</div>';
            echo '</div>';
            echo '</div>';
        }
        echo '</div>';
        ?>
        <style>
		.skill-tools-main-title {
			font-weight: 700;
		}
        .skill-tools-main-title {
            width: 100%;
        }
        .skill-tools-list {
            display: flex;
            flex-direction: row;
            align-items: flex-start;
            justify-content: center;
            gap: 20px;
            width: 100%;
            flex-wrap: wrap;
        }
        .skill-tool-item {
            /* width: 210px; */
            max-width: 100%;
            flex: 0 0 auto;
            margin: 0;
            display: flex;
            align-items: center;
            padding: 12px 18px;
            box-sizing: border-box;
            background: #151415;
            border: 1px solid #333;
            border-radius: 12px;
            transition: box-shadow .2s;
        }
        .skill-tool-item:hover {
            box-shadow: 0 2px 12px 0 rgba(0,0,0,0.10);
            cursor: pointer;
        }
        .skill-tool-img-wrap {
            display: flex;
            align-items: center;
            justify-content: center;
            min-width: 56px;
            min-height: 56px;
            background: #151415;
            border-radius: 12px;
        }
        .skill-tool-img {
            display: block;
            filter: grayscale(100%);
            transition: filter .3s;
        }
        .skill-tool-item:hover .skill-tool-img {
            filter: none !important;
        }
        .skill-tool-img-link {
            display: inline-block;
        }
        .skill-tool-img-link {
            background: none !important;
            border: none !important;
            border-radius: 0 !important;
            padding: 0 !important;
            margin: 0 !important;
            box-shadow: none !important;
        }
        .skill-tool-img-link:active,
        .skill-tool-img-link:visited,
        .skill-tool-img-link:focus {
            background: none !important;
            color: inherit !important;
        }
        @media (max-width: 900px) {
            .skill-tools-list {
                flex-direction: column;
                align-items: center;
                gap: 14px;
            }
            .skill-tool-item {
                max-width: 100%;
                width: 100%;
            }
        }
        </style>
        <?php
    }

    protected function _content_template() {
        ?>
        <# if(settings.main_title){ #>
        <div class="skill-tools-main-title" style="width:100%;">{{{ settings.main_title }}}</div>
        <# } #>
        <div class="skill-tools-list" style="display:flex;flex-direction:row;align-items:flex-start;justify-content:center;gap:20px;width:100%;flex-wrap:wrap;">
            <# _.each(settings.tools_list, function(item) { #>
                <div class="skill-tool-item">
                    <span class="skill-tool-img-wrap" style="display:flex;align-items:center;justify-content:center;min-width:56px;min-height:56px;">
                        <# if (item.tool_link && item.tool_link.url) { #>
                            <a href="{{ item.tool_link.url }}" class="skill-tool-img-link" <# if(item.tool_link.is_external){ #>target="_blank"<# } #> <# if(item.tool_link.nofollow){ #>rel="nofollow"<# } #> style="display:inline-block;">
                        <# } #>
                        <img src="{{ item.tool_image.url }}" alt="{{ item.tool_title }}" class="skill-tool-img" />
                        <# if (item.tool_link && item.tool_link.url) { #>
                            </a>
                        <# } #>
                    </span>
                    <div style="flex:1;text-align:right;padding-right:16px;">
                        <div class="skill-tool-title">{{{ item.tool_title }}}</div>
                        <div class="skill-tool-desc">{{{ item.tool_desc }}}</div>
                    </div>
                </div>
            <# }); #>
        </div>
        
        <?php
    }
}
