<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_project_links_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'skill_project_links_Widget';
    }
    public function get_title() {
        return esc_html__('لینک‌های پروژه', 'skill');
    }
    public function get_icon() {
        return 'eicon-link';
    }
    public function get_categories() {
        return ['skill-category'];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات لینک‌ها', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__('عنوان بخش', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('لینک ها و منابع', 'skill'),
                'placeholder' => esc_html__('عنوان بخش را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'links_layout',
            [
                'label' => esc_html__('طرح نمایش', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid' => esc_html__('شبکه‌ای', 'skill'),
                    'list' => esc_html__('لیستی', 'skill'),
                    'buttons' => esc_html__('دکمه‌ها', 'skill'),
                ],
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => esc_html__('تعداد ستون‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => esc_html__('1 ستون', 'skill'),
                    '2' => esc_html__('2 ستون', 'skill'),
                    '3' => esc_html__('3 ستون', 'skill'),
                    '4' => esc_html__('4 ستون', 'skill'),
                ],
                'condition' => [
                    'links_layout' => 'grid',
                ],
            ]
        );

        $this->add_control(
            'show_live_url',
            [
                'label' => esc_html__('نمایش لینک زنده', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_github_url',
            [
                'label' => esc_html__('نمایش GitHub', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_demo_url',
            [
                'label' => esc_html__('نمایش دمو', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_documentation_url',
            [
                'label' => esc_html__('نمایش مستندات', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .links-title',
            ]
        );

        $this->add_control(
            'link_background_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه لینک', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-link' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_text_color',
            [
                'label' => esc_html__('رنگ متن لینک', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_hover_background_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه لینک (هوور)', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-link:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_hover_text_color',
            [
                'label' => esc_html__('رنگ متن لینک (هوور)', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-link:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        $post_id = get_the_ID();
        
        // Get project links
        $live_url = get_post_meta($post_id, '_project_live_url', true);
        $github_url = get_post_meta($post_id, '_project_github_url', true);
        $demo_url = get_post_meta($post_id, '_project_demo_url', true);
        $documentation_url = get_post_meta($post_id, '_project_documentation_url', true);
        
        // Check if any links exist
        $has_links = false;
        if (($settings['show_live_url'] === 'yes' && $live_url) ||
            ($settings['show_github_url'] === 'yes' && $github_url) ||
            ($settings['show_demo_url'] === 'yes' && $demo_url) ||
            ($settings['show_documentation_url'] === 'yes' && $documentation_url)) {
            $has_links = true;
        }

        if (!$has_links) {
            return;
        }

        $links_layout = $settings['links_layout'];
        $columns = $settings['columns'];
        ?>
        <div class="skill-project-links-widget">
            <div class="links-container links-<?php echo esc_attr($links_layout); ?>">
                <?php if ($settings['section_title']): ?>
                    <h3 class="links-title"><?php echo esc_html($settings['section_title']); ?></h3>
                <?php endif; ?>
                
                <div class="links-grid links-columns-<?php echo esc_attr($columns); ?>">
                    <?php if ($settings['show_live_url'] === 'yes' && $live_url): ?>
                        <a href="<?php echo esc_url($live_url); ?>" class="project-link live-link" target="_blank">
                            <i class="fas fa-external-link-alt"></i>
                            <span><?php _e('مشاهده پروژه زنده', 'skill'); ?></span>
                        </a>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_github_url'] === 'yes' && $github_url): ?>
                        <a href="<?php echo esc_url($github_url); ?>" class="project-link github-link" target="_blank">
                            <i class="fab fa-github"></i>
                            <span><?php _e('مشاهده کد در GitHub', 'skill'); ?></span>
                        </a>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_demo_url'] === 'yes' && $demo_url): ?>
                        <a href="<?php echo esc_url($demo_url); ?>" class="project-link demo-link" target="_blank">
                            <i class="fas fa-play"></i>
                            <span><?php _e('مشاهده دمو', 'skill'); ?></span>
                        </a>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_documentation_url'] === 'yes' && $documentation_url): ?>
                        <a href="<?php echo esc_url($documentation_url); ?>" class="project-link docs-link" target="_blank">
                            <i class="fas fa-book"></i>
                            <span><?php _e('مشاهده مستندات', 'skill'); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <style>
        .skill-project-links-widget {
            margin: 2rem 0;
        }
        
        .links-container {
            padding: 2rem 0;
        }
        
        .links-title {
            margin-bottom: 2rem;
            font-size: 1.5rem;
            font-weight: 600;
            color: #333;
            text-align: center;
        }
        
        /* Grid Layout */
        .links-grid .links-grid {
            display: grid;
            gap: 1rem;
        }
        
        .links-columns-1 { grid-template-columns: 1fr; }
        .links-columns-2 { grid-template-columns: repeat(2, 1fr); }
        .links-columns-3 { grid-template-columns: repeat(3, 1fr); }
        .links-columns-4 { grid-template-columns: repeat(4, 1fr); }
        
        /* List Layout */
        .links-list .links-grid {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }
        
        /* Buttons Layout */
        .links-buttons .links-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            justify-content: center;
        }
        
        .links-buttons .project-link {
            flex: 0 0 auto;
        }
        
        /* Common Link Styles */
        .project-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem 1.5rem;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 500;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        
        .project-link:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
            color: white;
            text-decoration: none;
        }
        
        .project-link i {
            font-size: 1.2rem;
        }
        
        .project-link span {
            font-size: 0.95rem;
        }
        
        /* Specific Link Colors */
        .live-link {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
        }
        
        .live-link:hover {
            box-shadow: 0 8px 25px rgba(40, 167, 69, 0.4);
        }
        
        .github-link {
            background: linear-gradient(135deg, #333 0%, #6c757d 100%);
            box-shadow: 0 4px 15px rgba(51, 51, 51, 0.3);
        }
        
        .github-link:hover {
            box-shadow: 0 8px 25px rgba(51, 51, 51, 0.4);
        }
        
        .demo-link {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
        }
        
        .demo-link:hover {
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.4);
        }
        
        .docs-link {
            background: linear-gradient(135deg, #fd7e14 0%, #e83e8c 100%);
            box-shadow: 0 4px 15px rgba(253, 126, 20, 0.3);
        }
        
        .docs-link:hover {
            box-shadow: 0 8px 25px rgba(253, 126, 20, 0.4);
        }
        
        @media (max-width: 768px) {
            .links-columns-2,
            .links-columns-3,
            .links-columns-4 {
                grid-template-columns: 1fr;
            }
            
            .links-buttons .links-grid {
                flex-direction: column;
            }
            
            .project-link {
                justify-content: center;
            }
        }
        </style>
        <?php
    }
}
