<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_project_info_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'skill_project_info_Widget';
    }
    public function get_title() {
        return esc_html__('اطلاعات پروژه', 'skill');
    }
    public function get_icon() {
        return 'eicon-info-circle';
    }
    public function get_categories() {
        return ['skill-category'];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات نمایش', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__('عنوان بخش', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('اطلاعات پروژه', 'skill'),
                'placeholder' => esc_html__('عنوان بخش را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'show_client',
            [
                'label' => esc_html__('نمایش نام مشتری', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_status',
            [
                'label' => esc_html__('نمایش وضعیت', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_timeline',
            [
                'label' => esc_html__('نمایش زمانبندی', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_duration',
            [
                'label' => esc_html__('نمایش مدت زمان', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_budget',
            [
                'label' => esc_html__('نمایش بودجه', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_scale',
            [
                'label' => esc_html__('نمایش مقیاس', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_address',
            [
                'label' => esc_html__('نمایش آدرس', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_technologies',
            [
                'label' => esc_html__('نمایش تکنولوژی‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-info-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .project-info-title',
            ]
        );

        $this->add_control(
            'label_color',
            [
                'label' => esc_html__('رنگ برچسب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'value_color',
            [
                'label' => esc_html__('رنگ مقادیر', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .info-value' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-info-container' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        $post_id = get_the_ID();
        
        // Get project meta data
        $client_name = get_post_meta($post_id, '_client_name', true);
        $project_status = get_post_meta($post_id, '_project_status', true);
        $start_number = get_post_meta($post_id, '_start_number', true);
        $end_number = get_post_meta($post_id, '_end_number', true);
        $project_duration = get_post_meta($post_id, '_project_duration', true);
        $project_budget = get_post_meta($post_id, '_project_budget', true);
        $project_scale = get_post_meta($post_id, '_project_scale', true);
        $technologies = get_post_meta($post_id, '_technologies', true);
        $project_address = get_post_meta($post_id, '_project_address', true);

        // Check if any data exists
        $has_data = false;
        if (($settings['show_client'] === 'yes' && $client_name) ||
            ($settings['show_status'] === 'yes' && $project_status) ||
            ($settings['show_timeline'] === 'yes' && ($start_number || $end_number)) ||
            ($settings['show_duration'] === 'yes' && $project_duration) ||
            ($settings['show_budget'] === 'yes' && $project_budget) ||
            ($settings['show_scale'] === 'yes' && $project_scale) ||
            ($settings['show_address'] === 'yes' && $project_address) ||
            ($settings['show_technologies'] === 'yes' && $technologies)) {
            $has_data = true;
        }

        if (!$has_data) {
            return;
        }

        // Helper function to get status label
        function get_project_status_label($status) {
            $status_labels = array(
                'completed' => __('تکمیل شده', 'skill'),
                'in_progress' => __('در حال انجام', 'skill'),
                'on_hold' => __('متوقف شده', 'skill'),
                'cancelled' => __('لغو شده', 'skill')
            );
            return isset($status_labels[$status]) ? $status_labels[$status] : $status;
        }

        // Helper function to get scale label
        function get_project_scale_label($scale) {
            $scale_labels = array(
                'small' => __('کوچک', 'skill'),
                'medium' => __('متوسط', 'skill'),
                'large' => __('بزرگ', 'skill'),
                'enterprise' => __('سازمانی', 'skill')
            );
            return isset($scale_labels[$scale]) ? $scale_labels[$scale] : $scale;
        }

        ?>
        <div class="skill-project-info-widget">
            <div class="project-info-container">
                <?php if ($settings['section_title']): ?>
                    <h3 class="project-info-title"><?php echo esc_html($settings['section_title']); ?></h3>
                <?php endif; ?>
                
                <div class="project-info-grid">
                    <?php if ($settings['show_client'] === 'yes' && $client_name): ?>
                        <div class="info-item">
                            <span class="info-label"><?php _e('مشتری:', 'skill'); ?></span>
                            <span class="info-value"><?php echo esc_html($client_name); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_status'] === 'yes' && $project_status): ?>
                        <div class="info-item">
                            <span class="info-label"><?php _e('وضعیت:', 'skill'); ?></span>
                            <span class="info-value status-<?php echo esc_attr($project_status); ?>">
                                <?php echo get_project_status_label($project_status); ?>
                            </span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_timeline'] === 'yes' && ($start_number || $end_number)): ?>
                        <div class="info-item">
                            <span class="info-label"><?php _e('دوره زمانی:', 'skill'); ?></span>
                            <span class="info-value">
                                <?php 
                                if ($start_number && $end_number) {
                                    echo esc_html($start_number) . ' - ' . esc_html($end_number);
                                } elseif ($start_number) {
                                    echo esc_html($start_number);
                                } elseif ($end_number) {
                                    echo esc_html($end_number);
                                }
                                ?>
                            </span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_duration'] === 'yes' && $project_duration): ?>
                        <div class="info-item">
                            <span class="info-label"><?php _e('مدت زمان:', 'skill'); ?></span>
                            <span class="info-value"><?php echo esc_html($project_duration); ?> <?php _e('ماه', 'skill'); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_budget'] === 'yes' && $project_budget): ?>
                        <div class="info-item">
                            <span class="info-label"><?php _e('بودجه:', 'skill'); ?></span>
                            <span class="info-value"><?php echo esc_html($project_budget); ?> <?php _e('تومان', 'skill'); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_scale'] === 'yes' && $project_scale): ?>
                        <div class="info-item">
                            <span class="info-label"><?php _e('مقیاس:', 'skill'); ?></span>
                            <span class="info-value"><?php echo get_project_scale_label($project_scale); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_address'] === 'yes' && $project_address): ?>
                        <div class="info-item">
                            <span class="info-label"><?php _e('آدرس:', 'skill'); ?></span>
                            <span class="info-value"><?php echo esc_html($project_address); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
                
                <?php if ($settings['show_technologies'] === 'yes' && $technologies): ?>
                    <div class="technologies-section">
                        <h4><?php _e('تکنولوژی های استفاده شده', 'skill'); ?></h4>
                        <div class="technologies-list">
                            <?php 
                            $tech_array = array_map('trim', explode(',', $technologies));
                            foreach ($tech_array as $tech): ?>
                                <span class="tech-tag"><?php echo esc_html($tech); ?></span>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <style>
        .skill-project-info-widget {
            margin: 2rem 0;
        }
        
        .project-info-container {
            background: #f8f9fa;
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        
        .project-info-title {
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
            font-weight: 600;
            color: #333;
            border-bottom: 2px solid #007cba;
            padding-bottom: 0.5rem;
        }
        
        .project-info-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .project-info-grid .info-item {
            flex: 1 1 250px;
        }
        
        .info-item {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            padding: 1rem;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }
        
        /* Prevent long text/URLs from overflowing */
        .info-item .info-label,
        .info-item .info-value {
            min-width: 0;
            overflow-wrap: anywhere;
            word-break: break-word;
            white-space: normal;
            max-width: 100%;
        }

        .info-item .info-label {
            flex: 0 0 auto;
            margin-left: 8px;
        }

        .info-item .info-value {
            flex: 1 1 auto;
            text-align: left;
        }

        .info-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .info-label {
            font-weight: 600;
            color: #666;
            font-size: 0.9rem;
        }
        
        .info-value {
            font-weight: 500;
            color: #333;
            text-align: left;
        }
        
        .status-completed {
            color: #28a745;
            font-weight: 600;
        }
        
        .status-in_progress {
            color: #ffc107;
            font-weight: 600;
        }
        
        .status-on_hold {
            color: #fd7e14;
            font-weight: 600;
        }
        
        .status-cancelled {
            color: #dc3545;
            font-weight: 600;
        }
        
        .technologies-section {
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid #dee2e6;
        }
        
        .technologies-section h4 {
            margin-bottom: 1rem;
            color: #333;
            font-size: 1.1rem;
        }
        
        .technologies-list {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
        }
        
        .tech-tag {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .tech-tag:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        }
        
        @media (max-width: 768px) {
            .project-info-grid {
                display: flex;
            }
            .project-info-grid .info-item {
                flex: 1 1 100%;
            }
            
            .info-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
            }
            
            .project-info-container {
                padding: 1.5rem;
            }
        }
        </style>
        <?php
    }
}
