<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Prevent direct access

class skill_progressbar_line_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_progressbar_line';
    }

    public function get_title() {
        return esc_html__( 'نوار پیشرفت خطی', 'skill' );
    }

    public function get_icon() {
        return 'eicon-skill-bar';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    public function get_keywords() {
        return [ 'نوار پیشرفت', 'خطی', 'مهارت', 'skill', 'progress', 'line' ];
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'محتوای نوار پیشرفت', 'skill' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_title_main',
            [
                'label' => esc_html__( 'نمایش عنوان اصلی', 'skill' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'نمایش', 'skill' ),
                'label_off' => esc_html__( 'مخفی', 'skill' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'title_main',
            [
                'label' => esc_html__( 'عنوان اصلی', 'skill' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'مهارت‌های من', 'skill' ),
                'placeholder' => esc_html__( 'عنوان را وارد کنید', 'skill' ),
                'condition' => [ 'show_title_main' => 'yes' ],
            ]
        );

        // Repeater for progress bars
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'skill_name',
            [
                'label' => esc_html__( 'نام مهارت', 'skill' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'C++', 'skill' ),
                'placeholder' => esc_html__( 'نام مهارت را وارد کنید', 'skill' ),
            ]
        );

        $repeater->add_control(
            'skill_percent',
            [
                'label' => esc_html__( 'درصد مهارت', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 90,
                ],
            ]
        );

        $repeater->add_control(
            'progress_color',
            [
                'label' => esc_html__( 'رنگ نوار پیشرفت', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4CAF50',
            ]
        );

        $this->add_control(
            'progress_bars',
            [
                'label' => esc_html__( 'نوارهای پیشرفت', 'skill' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'skill_name' => esc_html__( 'C++', 'skill' ),
                        'skill_percent' => [ 'size' => 90, 'unit' => '%' ],
                        'progress_color' => '#2c3e50',
                    ],
                    [
                        'skill_name' => esc_html__( 'JavaScript', 'skill' ),
                        'skill_percent' => [ 'size' => 75, 'unit' => '%' ],
                        'progress_color' => '#3498db',
                    ],
                    [
                        'skill_name' => esc_html__( 'Spanish', 'skill' ),
                        'skill_percent' => [ 'size' => 60, 'unit' => '%' ],
                        'progress_color' => '#e74c3c',
                    ],
                    [
                        'skill_name' => esc_html__( 'French', 'skill' ),
                        'skill_percent' => [ 'size' => 80, 'unit' => '%' ],
                        'progress_color' => '#9b59b6',
                    ],
                ],
                'title_field' => '{{{ skill_name }}}',
            ]
        );

        $this->end_controls_section();

        // Style Section - Background
        $this->start_controls_section(
            'style_background_section',
            [
                'label' => esc_html__( 'استایل پس‌زمینه', 'skill' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => esc_html__( 'رنگ پس‌زمینه', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1e1f26',
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__track' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_border_radius',
            [
                'label' => esc_html__( 'گردی گوشه‌ها', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 25,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__track' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'background_padding',
            [
                'label' => esc_html__( 'فاصله داخلی', 'skill' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '12',
                    'right' => '20',
                    'bottom' => '12',
                    'left' => '20',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__track' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'background_margin',
            [
                'label' => esc_html__( 'فاصله خارجی', 'skill' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '15',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Progress Bar
        $this->start_controls_section(
            'style_progress_section',
            [
                'label' => esc_html__( 'استایل نوار پیشرفت', 'skill' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'progress_height',
            [
                'label' => esc_html__( 'ارتفاع نوار پیشرفت', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__fill' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'progress_border_radius',
            [
                'label' => esc_html__( 'گردی گوشه نوار پیشرفت', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 25,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 6,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__fill' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Typography
        $this->start_controls_section(
            'style_typography_section',
            [
                'label' => esc_html__( 'استایل متن', 'skill' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'main_title_color',
            [
                'label' => esc_html__( 'رنگ عنوان اصلی', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__main-title' => 'color: {{VALUE}};',
                ],
                'condition' => [ 'show_title_main' => 'yes' ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'main_title_typography',
                'selector' => '{{WRAPPER}} .skill-progress-line__main-title',
                'condition' => [ 'show_title_main' => 'yes' ],
            ]
        );

        $this->add_control(
            'skill_name_color',
            [
                'label' => esc_html__( 'رنگ نام مهارت', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__skill-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'skill_name_typography',
                'selector' => '{{WRAPPER}} .skill-progress-line__skill-name',
            ]
        );

        $this->add_control(
            'percent_color',
            [
                'label' => esc_html__( 'رنگ درصد', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .skill-progress-line__percent' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'percent_typography',
                'selector' => '{{WRAPPER}} .skill-progress-line__percent',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if ( empty( $settings['progress_bars'] ) ) return;
        ?>
        <div class="skill-progress-line-group" dir="rtl">
            <?php if ( !empty($settings['show_title_main']) && $settings['show_title_main'] === 'yes' && !empty($settings['title_main']) ) : ?>
                <div class="skill-progress-line__main-title"> 
                    <?php echo esc_html($settings['title_main']); ?>
                </div>
            <?php endif; ?>
            
            <?php foreach ( $settings['progress_bars'] as $index => $item ) :
                $percent = !empty($item['skill_percent']['size']) ? $item['skill_percent']['size'] : 0;
                $progress_color = !empty($item['progress_color']) ? $item['progress_color'] : '#4CAF50';
            ?>
                         <div class="skill-progress-line__item elementor-repeater-item-<?php echo esc_attr($index); ?>">
                 <div class="skill-progress-line__track">
                     <div class="skill-progress-line__fill" style="width: <?php echo esc_attr($percent); ?>%; background: <?php echo esc_attr($progress_color); ?>;">
                         <div class="skill-progress-line__content">
                             <span class="skill-progress-line__skill-name"><?php echo esc_html($item['skill_name']); ?></span>
                             <span class="skill-progress-line__percent"><?php echo esc_html($percent); ?>٪</span>
                         </div>
                     </div>
                 </div>
             </div>
            <?php endforeach; ?>
        </div>

        <style>
        .skill-progress-line-group {
            width: 100%;
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }
        
        .skill-progress-line__main-title {
            font-weight: 700;
            font-size: 1.2em;
            margin-bottom: 20px;
            line-height: 1.5;
            color: #ffffff;
            width: 100%;
        }
        
        .skill-progress-line__item {
            flex: 0 0 calc(50% - 10px);
            min-width: 300px;
        }
        
        .skill-progress-line__track {
            background: linear-gradient(145deg, #1e1f26, #dfdfdf);
            border-radius: 25px;
            padding: 8px;
            box-shadow: inset 6px 6px 12px rgba(0, 0, 0, 0.5),
                        inset -6px -6px 12px rgba(255, 255, 255, 0.08);
            position: relative;
            height: 50px;
            display: flex;
            align-items: center;
        }
        
        .skill-progress-line__fill {
            height: 100%;
            border-radius: 20px;
            transition: width 1.5s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
        }
        
        .skill-progress-line__content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
            z-index: 2;
            position: relative;
        }
        
        .skill-progress-line__skill-name {
            font-weight: 600;
            font-size: 1em;
            color: #ffffff;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
        }
        
        .skill-progress-line__percent {
            font-weight: 700;
            font-size: 0.95em;
            color: #ffffff;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
        }
        
                                                                       /* Default colors for different progress bars - only if no custom color is set */
           .elementor-repeater-item-0 .skill-progress-line__fill:not([style*="background"]) {
               background: #4a5568;
           }
           
           .elementor-repeater-item-1 .skill-progress-line__fill:not([style*="background"]) {
               background: #3182ce;
           }
           
           .elementor-repeater-item-2 .skill-progress-line__fill:not([style*="background"]) {
               background: #e53e3e;
           }
           
           .elementor-repeater-item-3 .skill-progress-line__fill:not([style*="background"]) {
               background: #805ad5;
           }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .skill-progress-line__item {
                flex: 0 0 100%;
                min-width: auto;
            }
            
            .skill-progress-line__track {
                padding: 6px;
                height: 45px;
            }
            
            .skill-progress-line__fill {
                padding: 0 15px;
            }
            
            .skill-progress-line__skill-name {
                font-size: 0.9em;
            }
            
            .skill-progress-line__percent {
                font-size: 0.85em;
            }
        }
        </style>
        <?php
    }
}
