<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

class skill_progress_bar_circle_Widget extends Widget_Base {

    public function get_name() {
        return 'skill_progress_bar_circle';
    }

    public function get_title() {
        return __( 'نوار پیشرفت دایره‌ای', 'skill' );
    }

    public function get_icon() {
        return 'eicon-skill-bar';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'محتوا', 'skill' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'widget_title',
            [
                'label' => __( 'عنوان کلی ویجت', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'عنوان کلی', 'skill' ),
                'placeholder' => __( 'مثال: مهارت‌های من', 'skill' ),
            ]
        );
        $this->add_control(
            'show_widget_title',
            [
                'label' => __( 'نمایش عنوان ویجت', 'skill' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'نمایش', 'skill' ),
                'label_off' => __( 'مخفی', 'skill' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'percent',
            [
                'label' => __( 'درصد', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 95,
                ],
            ]
        );

        $repeater->add_control(
            'main_value',
            [
                'label' => __( 'مقدار اصلی (مرکز دایره)', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'مثال: +95 یا 95K یا 95٪', 'skill' ),
                'default' => '',
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __( 'عنوان', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'عملکرد', 'skill' ),
            ]
        );

        $repeater->add_control(
            'circle_color',
            [
                'label' => __( 'رنگ دایره', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#22b573',
            ]
        );

        $repeater->add_control(
            'bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه دایره', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#e6e9ef',
            ]
        );

        $repeater->add_control(
            'size',
            [
                'label' => __( 'اندازه دایره (پیکسل)', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 60,
                        'max' => 400,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 120,
                ],
            ]
        );

        $repeater->add_control(
            'thickness',
            [
                'label' => __( 'ضخامت دایره', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
            ]
        );

        $repeater->add_control(
            'text_color',
            [
                'label' => __( 'رنگ متن', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#2d3a4a',
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => __( 'موارد', 'skill' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'percent' => ['size' => 95, 'unit' => '%'],
                        'main_value' => '',
                        'title' => __( 'عملکرد', 'skill' ),
                        'circle_color' => '#22b573',
                        'bg_color' => '#e6e9ef',
                        'size' => ['size' => 120, 'unit' => 'px'],
                        'thickness' => ['size' => 10, 'unit' => 'px'],
                        'text_color' => '#2d3a4a',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'widget_title_style_section',
            [
                'label' => __( 'استایل عنوان کلی', 'skill' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'widget_title_color',
            [
                'label' => __( 'رنگ عنوان', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#2d3a4a',
                'selectors' => [
                    '{{WRAPPER}} .skill-circle-bar-widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'widget_title_font_size',
            [
                'label' => __( 'سایز فونت عنوان (px)', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 24,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-circle-bar-widget-title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $widget_title = !empty($settings['widget_title']) ? $settings['widget_title'] : '';
        $show_widget_title = !empty($settings['show_widget_title']) && $settings['show_widget_title'] === 'yes';
        if ( !empty($settings['items']) ) {
            echo '<div class="skill-circle-bar-widget-wrapper">';
            if ($widget_title && $show_widget_title) {
                echo '<div class="skill-circle-bar-widget-title" style="text-align:right;font-weight:bold;margin-bottom:24px;">' . esc_html($widget_title) . '</div>';
            }
            echo '<div class="skill-circle-bar-list" style="display:flex;gap:24px;flex-wrap:wrap;justify-content:center;">';
            foreach ( $settings['items'] as $item ) {
                $percent = !empty($item['percent']['size']) ? $item['percent']['size'] : 0;
                $main_value = !empty($item['main_value']) ? $item['main_value'] : $percent . '%';
                $title = $item['title'];
                $size = !empty($item['size']['size']) ? $item['size']['size'] : 120;
                $thickness = !empty($item['thickness']['size']) ? $item['thickness']['size'] : 10;
                $circle_color = !empty($item['circle_color']) ? $item['circle_color'] : '#22b573';
                $bg_color = !empty($item['bg_color']) ? $item['bg_color'] : '#e6e9ef';
                $text_color = !empty($item['text_color']) ? $item['text_color'] : '#2d3a4a';

                $radius = ($size - $thickness) / 2;
                $circumference = 2 * pi() * $radius;
                $offset = $circumference * (1 - $percent / 100);
                ?>
                <div class="skill-circle-bar" style="width:<?php echo esc_attr($size); ?>px;height:<?php echo esc_attr($size); ?>px;position:relative;display:inline-block;">
                    <svg width="<?php echo esc_attr($size); ?>" height="<?php echo esc_attr($size); ?>" style="transform: rotate(-90deg);">
                        <circle
                            class="skill-circle-bar__bg"
                            cx="<?php echo $size/2; ?>"
                            cy="<?php echo $size/2; ?>"
                            r="<?php echo $radius; ?>"
                            stroke-width="<?php echo $thickness; ?>"
                            fill="none"
                            stroke="<?php echo esc_attr($bg_color); ?>"
                        />
                        <circle
                            class="skill-circle-bar__progress"
                            cx="<?php echo $size/2; ?>"
                            cy="<?php echo $size/2; ?>"
                            r="<?php echo $radius; ?>"
                            stroke-width="<?php echo $thickness; ?>"
                            fill="none"
                            stroke-linecap="round"
                            stroke-dasharray="<?php echo $circumference; ?>"
                            stroke-dashoffset="<?php echo $offset; ?>"
                            stroke="<?php echo esc_attr($circle_color); ?>"
                            style="transition: stroke-dashoffset 1s;"
                        />
                    </svg>
                    <div style="position:absolute;top:0;left:0;width:100%;height:100%;display:flex;flex-direction:column;align-items:center;justify-content:center;">
                        <div class="skill-circle-bar__percent" style="font-size:1.2em;font-weight:bold;color:<?php echo esc_attr($text_color); ?>">
                            <?php echo esc_html($main_value); ?>
                        </div>
                        <div class="skill-circle-bar__title" style="font-size:1em;color:<?php echo esc_attr($text_color); ?>">
                            <?php echo esc_html($title); ?>
                        </div>
                    </div>
                </div>
                <?php
            }
            echo '</div></div>';
        }
    }
}