<?php


class skill_pricing_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'skill_pricing_Widget';
    }

    public function get_title() {
        return __('جعبه قیمت‌گذاری', 'skill');
    }

    public function get_icon() {
        return 'eicon-price-table';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __('عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('عنوان پلن', 'skill'),
            ]
        );

        $repeater->add_control(
            'original_price',
            [
                'label' => __('قیمت اصلی', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '100,000',
            ]
        );

        $repeater->add_control(
            'discounted_price',
            [
                'label' => __('قیمت با تخفیف', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '85,000',
            ]
        );

        $repeater->add_control(
            'features',
            [
                'label' => __('ویژگی‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => __('هر ویژگی را در یک خط وارد کنید', 'skill'),
                'default' => __("ویژگی اول\nویژگی دوم\nویژگی سوم", 'skill'),
            ]
        );

        // رنگ های نوار بالای کارت (مطابق طرح)
        $repeater->add_control(
            'accent_start_color',
            [
                'label' => __('رنگ شروع نوار بالایی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00b5ff',
            ]
        );

        $repeater->add_control(
            'accent_end_color',
            [
                'label' => __('رنگ پایان نوار بالایی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00d1b2',
            ]
        );

        // نماد ارز و دوره پرداخت
        $repeater->add_control(
            'currency_symbol',
            [
                'label' => __('نماد ارز', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '$',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'period_text',
            [
                'label' => __('دوره پرداخت', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('/ ماه', 'skill'),
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label' => __('متن دکمه', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('سفارش طرح', 'skill'),
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => __('لینک دکمه', 'skill'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://example.com',
            ]
        );

        // پلن پیشنهادی + متن بج
        $repeater->add_control(
            'is_recommended',
            [
                'label' => __('پلن پیشنهادی', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'skill'),
                'label_off' => __('خیر', 'skill'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $repeater->add_control(
            'badge_text',
            [
                'label' => __('متن بج', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('پیشنهادی', 'skill'),
                'condition' => [ 'is_recommended' => 'yes' ],
            ]
        );

        $repeater->add_control(
            'badge_position',
            [
                'label' => __('مکان بج', 'skill'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('چپ', 'skill'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'right' => [
                        'title' => __('راست', 'skill'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => false,
                'condition' => [ 'is_recommended' => 'yes' ],
            ]
        );

        $this->add_control(
            'pricing_boxes',
            [
                'label' => __('جعبه‌های قیمت', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('با پشتیبانی حرفه‌ای', 'skill'),
                        'original_price' => '105,000',
                        'discounted_price' => '95,000',
                        'features' => __("لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ", 'skill'),
                        'button_text' => __('سفارش طرح', 'skill'),
                        'accent_start_color' => '#00b5ff',
                        'accent_end_color' => '#00d1b2',
                    ],
                    [
                        'title' => __('بدون پشتیبانی', 'skill'),
                        'original_price' => '95,000',
                        'discounted_price' => '75,000',
                        'features' => __("لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ", 'skill'),
                        'button_text' => __('سفارش طرح', 'skill'),
                        'accent_start_color' => '#00b5ff',
                        'accent_end_color' => '#00d1b2',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // پس‌زمینه کارت (Classic/Gradient)
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_background',
                'label' => __('پس‌زمینه کارت', 'skill'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .pricing_boxs',
            ]
        );

        // سایه کارت
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __('سایه کارت', 'skill'),
                'selector' => '{{WRAPPER}} .pricing_boxs',
            ]
        );

        // گردی گوشه‌های کارت
        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => __('گردی گوشه‌های کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [ 'top' => 20, 'right' => 20, 'bottom' => 20, 'left' => 20, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_boxs' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // فاصله داخلی کارت
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __('فاصله داخلی کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem'],
                'default' => [ 'top' => 28, 'right' => 28, 'bottom' => 28, 'left' => 28, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_boxs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // جابجایی کارت هنگام هاور
        $this->add_control(
            'hover_lift',
            [
                'label' => __('جابجایی کارت هنگام هاور (px)', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [ 'px' => [ 'min' => 0, 'max' => 24, 'step' => 1 ] ],
                'default' => [ 'size' => 8, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_boxs:hover' => 'transform: translateY(-{{SIZE}}{{UNIT}});',
                ],
            ]
        );

        // شدت نور گوشه‌ها هنگام هاور
        $this->add_control(
            'corner_glow_opacity',
            [
                'label' => __('شدت نور گوشه‌ها هنگام هاور', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [ 'px' => [ 'min' => 0, 'max' => 1, 'step' => 0.05 ] ],
                'default' => [ 'size' => 1 ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_boxs:hover::after' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'gap_between_boxes',
            [
                'label' => __('فاصله بین جعبه‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_boxes' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_border_color',
            [
                'label' => __('رنگ حاشیه جعبه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f214',
                'selectors' => [
                    '{{WRAPPER}} .pricing_boxs' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#686868',
                'selectors' => [
                    '{{WRAPPER}} .plan_title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label' => __('رنگ قیمت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .pricing_box ins' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'features_color',
            [
                'label' => __('رنگ ویژگی‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#686868',
                'selectors' => [
                    '{{WRAPPER}} .pricing_box h5' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('رنگ آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#39d127',
                'selectors' => [
                    '{{WRAPPER}} .pricing_box h5 i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_border_color',
            [
                'label' => __('رنگ حاشیه دکمه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ddd',
                'selectors' => [
                    '{{WRAPPER}} .skill_order' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_border_hover_color',
            [
                'label' => __('رنگ حاشیه دکمه هنگام hover', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .skill_order:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_hover_bg',
            [
                'label' => __('رنگ پس‌زمینه دکمه هنگام hover', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .skill_order:hover' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => __('رنگ متن دکمه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#686868',
                'selectors' => [
                    '{{WRAPPER}} .skill_order a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_text_hover_color',
            [
                'label' => __('رنگ متن دکمه هنگام hover', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .skill_order:hover a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="pricing_boxes d-flex flex-wrap justify-content-center mt-5">
            <?php 
            $boxes = array_slice((array) $settings['pricing_boxes'], 0, 3);
            $nonFeaturedCount = 0;
            foreach ($boxes as $box): ?>
                <?php
                $is_featured = !empty($box['is_recommended']) && $box['is_recommended'] === 'yes';
                $badge_side = !empty($box['badge_position']) ? $box['badge_position'] : 'left';
                $accent_start = !empty($box['accent_start_color']) ? $box['accent_start_color'] : '#00b5ff';
                $accent_end = !empty($box['accent_end_color']) ? $box['accent_end_color'] : '#00d1b2';
                $currency = !empty($box['currency_symbol']) ? $box['currency_symbol'] : '$';
                $period = !empty($box['period_text']) ? $box['period_text'] : __('/ ماه', 'skill');
                $discounted_clean = preg_replace('/[^\d]/', '', isset($box['discounted_price']) ? $box['discounted_price'] : '0');
                $amount_main = $discounted_clean !== '' ? $discounted_clean : '0';
                $amount_main_formatted = number_format((float) $amount_main, 0, '.', ',');

                // define order: featured in middle
                if ($is_featured) {
                    $order = 2;
                } else {
                    $nonFeaturedCount++;
                    $order = ($nonFeaturedCount === 1) ? 1 : 3;
                }
                ?>
                <div class="pricing_boxs d-flex overflow-hidden w-100 mt-4 <?php echo $is_featured ? 'is-featured' : ''; ?>" style="--accent-start: <?php echo esc_attr($accent_start); ?>; --accent-end: <?php echo esc_attr($accent_end); ?>; order: <?php echo (int) $order; ?>;">
                    <?php if ($is_featured): ?>
                        <span class="pricing_badge <?php echo $badge_side === 'right' ? 'is-right' : 'is-left'; ?>"><?php echo esc_html(!empty($box['badge_text']) ? $box['badge_text'] : __('پیشنهادی', 'skill')); ?></span>
                    <?php endif; ?>
                    <div class="pricing_box w-100">
                        <div class="pricing_header">
                            <div class="plan_title"><?php echo esc_html($box['title']); ?></div>
                        </div>
                        <div class="price_wrap">
                            <div class="price">
                                <span class="amount"><?php echo esc_html($amount_main_formatted); ?></span>
                                <span class="currency"><?php echo esc_html($currency); ?></span>
                                <small class="period"><?php echo esc_html($period); ?></small>
                            </div>
                            <?php if (!empty($box['original_price'])): ?>
                                <del><?php echo esc_html($box['original_price']); ?></del>
                            <?php endif; ?>
                        </div>

                        <?php
                        $features = explode("\n", $box['features']);
                        foreach ($features as $feature):
                            if (!empty(trim($feature))):
                                ?>
                                <h5><i class="fa-solid fa-circle-check"></i> <?php echo esc_html($feature); ?></h5>
                            <?php
                            endif;
                        endforeach;
                        ?>

                        <div class="skill_order <?php echo $is_featured ? 'is-outline' : 'is-filled'; ?>">
                            <a href="<?php echo esc_url($box['button_link']['url']); ?>"><?php echo esc_html($box['button_text']); ?></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
    }
}