<?php
if (!defined('ABSPATH')) exit;

class Skill_my_personal_mdern_Widget extends \Elementor\Widget_Base {
	public function get_name() { return 'skill_personal_modern_card'; }
	public function get_title() { return __('کارت رزومه مدرن', 'skill'); }
    public function get_icon() { return 'eicon-user-circle-o'; }
	public function get_categories() { return ['skill-category']; }

	protected function _register_controls() {
		// Content section
		$this->start_controls_section('spm_content', ['label' => __('محتوا', 'skill'), 'tab' => \Elementor\Controls_Manager::TAB_CONTENT]);
		$this->add_control('first_name', ['label' => __('نام', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('محمد', 'skill')]);
		$this->add_control('last_name', ['label' => __('نام خانوادگی', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('حیدری', 'skill')]);
		$this->add_control('avatar_image', ['label' => __('تصویر آواتار', 'skill'), 'type' => \Elementor\Controls_Manager::MEDIA, 'default' => ['url' => \Elementor\Utils::get_placeholder_image_src()]]);
		$this->add_control('contact_button_text', ['label' => __('متن دکمه ارتباط', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('ارتباط با من', 'skill')]);
		$this->add_control('contact_button_url', ['label' => __('لینک دکمه ارتباط', 'skill'), 'type' => \Elementor\Controls_Manager::URL, 'placeholder' => 'https://example.com', 'default' => ['url' => '#', 'is_external' => false, 'nofollow' => false]]);
		$this->add_control('meta_experience_label', ['label' => __('برچسب سابقه', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('سابقه', 'skill')]);
		$this->add_control('meta_experience_value', ['label' => __('مقدار سابقه', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('ده سال', 'skill')]);
		$this->add_control('meta_specialty_label', ['label' => __('برچسب تخصص', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('تخصص', 'skill')]);
		$this->add_control('meta_specialty_value', ['label' => __('مقدار تخصص', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('توسعه', 'skill')]);
		$this->add_control('meta_education_label', ['label' => __('برچسب تحصیلات', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('تحصیلات', 'skill')]);
		$this->add_control('meta_education_value', ['label' => __('مقدار تحصیلات', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('ارشد', 'skill')]);
		$this->add_control('bio_text', ['label' => __('متن توضیح', 'skill'), 'type' => \Elementor\Controls_Manager::TEXTAREA, 'default' => __('توسعه‌دهنده‌ای هستم که وردپرس را مانند کف دست می‌شناسم. مشکل را به من بگویید؛ من بهترین راه‌حل فنی و به‌صرفه را برای شما اجرا می‌کنم.', 'skill')]);
        $this->end_controls_section();

		// Text colors
		$this->start_controls_section('spm_style_colors', [
			'label' => __('رنگ‌ها', 'skill'),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		]);
		$this->add_control('color_name', [
			'label' => __('رنگ نام', 'skill'),
			'type'  => \Elementor\Controls_Manager::COLOR,
			'default' => '#ffffff',
			'selectors' => [
				'{{WRAPPER}} .spm-name' => 'color: {{VALUE}};',
			],
		]);
		$this->add_control('color_meta_label', [
			'label' => __('رنگ برچسب‌های متا', 'skill'),
			'type'  => \Elementor\Controls_Manager::COLOR,
			'default' => 'rgba(255,255,255,0.7)',
			'selectors' => [
				'{{WRAPPER}} .spm-meta .spm-label' => 'color: {{VALUE}};',
			],
		]);
		$this->add_control('color_meta_value', [
			'label' => __('رنگ مقدارهای متا', 'skill'),
			'type'  => \Elementor\Controls_Manager::COLOR,
			'default' => '#ffffff',
			'selectors' => [
				'{{WRAPPER}} .spm-meta .spm-value' => 'color: {{VALUE}};',
			],
		]);
		$this->add_control('color_bio_text', [
			'label' => __('رنگ متن توضیح', 'skill'),
			'type'  => \Elementor\Controls_Manager::COLOR,
			'default' => 'rgba(255,255,255,0.92)',
			'selectors' => [
				'{{WRAPPER}} .spm-bio' => 'color: {{VALUE}};',
			],
		]);
		$this->add_control('color_contact', [
			'label' => __('رنگ متن دکمه ارتباط', 'skill'),
			'type'  => \Elementor\Controls_Manager::COLOR,
			'default' => 'rgba(255,255,255,0.7)',
			'selectors' => [
				'{{WRAPPER}} .spm-contact' => 'color: {{VALUE}};',
			],
		]);
		$this->end_controls_section();

        // Avatar style controls
        $this->start_controls_section('spm_style_avatar', [
            'label' => __('استایل آواتار', 'skill'),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_control('avatar_border_color', [
            'label' => __('رنگ بردر آواتار', 'skill'),
            'type'  => \Elementor\Controls_Manager::COLOR,
            'default' => '#0E59F2',
            'selectors' => [
                '{{WRAPPER}} .spm-avatar' => 'border-color: {{VALUE}};',
            ],
        ]);
        $this->add_control('avatar_border_width', [
            'label' => __('ضخامت بردر آواتار', 'skill'),
            'type'  => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range' => [ 'px' => ['min' => 0, 'max' => 20] ],
            'default' => [ 'unit' => 'px', 'size' => 4 ],
            'selectors' => [
                '{{WRAPPER}} .spm-avatar' => 'border-width: {{SIZE}}{{UNIT}}; border-style: solid;',
            ],
        ]);
        $this->add_control('avatar_border_radius', [
            'label' => __('گردی گوشه آواتار', 'skill'),
            'type'  => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['%'],
            'range' => [ '%' => ['min' => 0, 'max' => 50] ],
            'default' => [ 'unit' => '%', 'size' => 50 ],
            'selectors' => [
                '{{WRAPPER}} .spm-avatar' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]);
        $this->end_controls_section();
	}

	protected function render() {
		$s = $this->get_settings_for_display();
		$full = trim(($s['first_name'] ?? '') . ' ' . ($s['last_name'] ?? ''));
		$url  = $s['contact_button_url']['url'] ?? '#';
		$tgt  = !empty($s['contact_button_url']['is_external']) ? '_blank' : '_self';
		?>
		<div class="spm-card" dir="rtl">
			<?php if (!empty($s['contact_button_text'])): ?>
			<a class="spm-contact" href="<?php echo esc_url($url); ?>" target="<?php echo esc_attr($tgt); ?>">
				<i class="fas fa-comments" aria-hidden="true"></i>
				<span><?php echo esc_html($s['contact_button_text']); ?></span>
			</a>
			<?php endif; ?>
			<div class="spm-avatar-wrap">
				<img class="spm-avatar" src="<?php echo esc_url($s['avatar_image']['url'] ?? ''); ?>" alt="<?php echo esc_attr($full); ?>" />
				<div class="spm-badge" title="status"><i class="fas fa-pen" aria-hidden="true"></i></div>
			</div>
			<h2 class="spm-name"><?php echo esc_html($full); ?></h2>
			<div class="spm-meta" aria-hidden="true">
				<div class="spm-item"><span class="spm-label"><?php echo esc_html($s['meta_experience_label']); ?>:</span><span class="spm-value"><?php echo esc_html($s['meta_experience_value']); ?></span></div>
				<div class="spm-item"><span class="spm-label"><?php echo esc_html($s['meta_specialty_label']); ?>:</span><span class="spm-value"><?php echo esc_html($s['meta_specialty_value']); ?></span></div>
				<div class="spm-item"><span class="spm-label"><?php echo esc_html($s['meta_education_label']); ?>:</span><span class="spm-value"><?php echo esc_html($s['meta_education_value']); ?></span></div>
			</div>
			<div class="spm-bio"><i class="fas fa-pen spm-bio-icon" aria-hidden="true"></i><p><?php echo esc_html($s['bio_text']); ?></p></div>
			<hr class="spm-sep" />
		</div>
		<style>
		.spm-card{position:relative;max-width:760px;margin:0 auto;padding:56px 40px 34px;box-sizing:border-box;color:#fff;text-align:center}
		.spm-contact{position:absolute;left:24px;top:22px;display:inline-flex;gap:10px;align-items:center;color:rgba(255,255,255,.7);font-size:14px;text-decoration:none}
		.spm-contact i{opacity:.9}
		.spm-avatar-wrap{width:140px;height:140px;margin:0 auto 18px;position:relative;border-radius:50%;display:flex;align-items:center;justify-content:center}
        .spm-avatar{width:145px;height:145px !important;border-radius:50%;object-fit:cover;display:block;z-index:2;box-shadow:0 6px 20px rgba(0,0,0,.6);border:0 solid transparent}
		.spm-badge{position:absolute;width:36px;height:36px;border-radius:50%;background:#fff;display:flex;align-items:center;justify-content:center;box-shadow:0 6px 18px rgba(0,0,0,.45);right:calc(50% - 60px);bottom:8px;transform:translate(28px,10px);z-index:3}
		.spm-badge i{color:#2b9cff}
		.spm-name{margin:6px 0 12px;font-size:28px;letter-spacing:.6px;font-weight:700}
		.spm-meta{display:flex;gap:34px;justify-content:center;align-items:center;color:rgba(255,255,255,.7);font-size:14px;margin-bottom:18px;flex-wrap:wrap}
		.spm-item{display:flex;gap:10px;align-items:center}
		.spm-label{font-size:13px;color:rgba(255,255,255,.7)}
		.spm-value{font-weight:600}
		.spm-bio{max-width:720px;margin:18px auto 20px;color:rgba(255,255,255,.92);line-height:1.9;font-size:15px;text-align:justify;padding:0 12px;display:flex;gap:10px;align-items:flex-start;border-top:1px solid rgba(255,255,255,0.12);border-bottom:1px solid rgba(255,255,255,0.12);padding-top:12px;padding-bottom:12px}
		.spm-bio-icon{opacity:.95}
		.spm-bio p{margin:0}
		.spm-sep{border:0;height:1px;background:linear-gradient(90deg, rgba(255,255,255,.06), rgba(255,255,255,.08));margin-top:26px;width:80%;margin-left:auto;margin-right:auto}
		@media(max-width:520px){.spm-card{padding:40px 20px}.spm-avatar{width:107px;height:109px !important}.spm-name{font-size:22px}.spm-meta{gap:18px;font-size:13px}.spm-badge{width:30px;height:30px}}
		</style>
		<?php
	}
}


