<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class skill_my_name_job_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'my_name_job_widget';
    }

    public function get_title() {
        return __('نام و شغل من', 'textdomain');
    }

    public function get_icon() {
        return 'eicon-heading';
    }

    public function get_categories() {
        return ['skill-category'];
    }



    protected function _register_controls() {
        // Content section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'first_name',
            [
                'label' => __('نام', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('محمد', 'skill'),
                'placeholder' => __('نام خود را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'last_name',
            [
                'label' => __('نام خانوادگی', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('حیدری', 'skill'),
                'placeholder' => __('نام خانوادگی خود را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'job_titles',
            [
                'label' => __('عنوان‌های شغلی', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'job_title',
                        'label' => __('عنوان شغلی', 'skill'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => __('توسعه دهنده وب', 'skill'),
                        'placeholder' => __('عنوان شغلی را وارد کنید', 'skill'),
                    ],
                ],
                'default' => [
                    [
                        'job_title' => __('توسعه دهنده وب', 'skill'),
                    ],
                    [
                        'job_title' => __('توسعه وردپرس', 'skill'),
                    ],
                    [
                        'job_title' => __('طراح محصول', 'skill'),
                    ],
                ],
                'title_field' => '{{{ job_title }}}',
            ]
        );

        $this->add_control(
            'animation_interval',
            [
                'label' => __('فاصله زمانی انیمیشن (میلی‌ثانیه)', 'skill'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 500,
                'max' => 10000,
                'step' => 100,
                'default' => 1500,
            ]
        );

        $this->end_controls_section();

        // Name Style Section
        $this->start_controls_section(
            'name_style_section',
            [
                'label' => __('استایل نام', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'label' => __('تایپوگرافی نام', 'skill'),
                'selector' => '{{WRAPPER}} .skill_my_name h1',
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => __('رنگ نام', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .skill_my_name h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'name_margin',
            [
                'label' => __('فاصله نام', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .skill_my_name h1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Job Title Style Section
        $this->start_controls_section(
            'job_style_section',
            [
                'label' => __('استایل عنوان شغلی', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'job_typography',
                'label' => __('تایپوگرافی عنوان شغلی', 'skill'),
                'selector' => '{{WRAPPER}} .animated-title',
            ]
        );

        $this->add_control(
            'job_color',
            [
                'label' => __('رنگ عنوان شغلی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .animated-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'job_min_width',
            [
                'label' => __('حداقل عرض', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 150,
                ],
                'selectors' => [
                    '{{WRAPPER}} .animated-title' => 'min-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'job_height',
            [
                'label' => __('ارتفاع', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .animated-title' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Container Style Section
        $this->start_controls_section(
            'container_style_section',
            [
                'label' => __('استایل کانتینر', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'container_gap',
            [
                'label' => __('فاصله بین عناصر', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .name-container' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_alignment',
            [
                'label' => __('تراز', 'skill'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __('شروع', 'skill'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('وسط', 'skill'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => __('پایان', 'skill'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'flex-start',
                'selectors' => [
                    '{{WRAPPER}} .skill_my_name' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Animation section
        $this->start_controls_section(
            'animation_section',
            [
                'label' => __('انیمیشن', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'animation_duration',
            [
                'label' => __('مدت انیمیشن (ثانیه)', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .fade-out' => 'animation-duration: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fade-in' => 'animation-duration: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'animation_distance',
            [
                'label' => __('فاصله حرکت (پیکسل)', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .fade-out' => '--animation-distance: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fade-in' => '--animation-distance: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        // Convert job titles to an array
        $job_titles = [];
        if (!empty($settings['job_titles'])) {
            foreach ($settings['job_titles'] as $job) {
                if (!empty($job['job_title'])) {
                    $job_titles[] = $job['job_title'];
                }
            }
        }
        
        // If there is no job title, add a default title.
        if (empty($job_titles)) {
            $job_titles = ['توسعه دهنده وب'];
        }
        
        $job_titles_json = wp_json_encode($job_titles);
        $animation_interval = $settings['animation_interval'] ?? 1500;
        ?>
        
        <style>
        .skill_my_name h1 {
            color: #fff;
        }

        .name-container {
            gap: 15px;
        }

        .full-name {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 10px;
        }

        .job-title-container {
            display: flex;
            justify-content: center;
            margin-top: 5px;
            width: 100%;
            text-align: center;
        }

        .animated-title {
            color: #fff;
            position: relative;
            min-width: 150px;
            height: 40px;
            display: inline-block;
            font-size: 17px;
        }

        .fade-out {
            animation: fadeOut 0.5s forwards;
        }

        .fade-in {
            animation: fadeIn 0.5s forwards;
        }

        @keyframes fadeOut {
            from { 
                opacity: 1; 
                transform: translateY(0); 
            }
            to { 
                opacity: 0; 
                transform: translateY(calc(-1 * var(--animation-distance, 10px))); 
            }
        }

        @keyframes fadeIn {
            from { 
                opacity: 0; 
                transform: translateY(calc(1 * var(--animation-distance, 10px))); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }

        /* Responsive styles */
        @media (max-width: 768px) {
            .skill_my_name h1 {
                font-size: 1.5rem;
            }
            
            .animated-title {
                font-size: 14px;
                min-width: 120px;
                height: 35px;
            }
            
            .name-container {
                gap: 10px;
            }
        }

        @media (max-width: 480px) {
            .skill_my_name h1 {
                font-size: 1.2rem;
            }
            
            .animated-title {
                font-size: 12px;
                min-width: 100px;
                height: 30px;
            }
            
            .name-container {
                gap: 8px;
            }
        }
        </style>
        
        <div class="skill_my_name d-flex flex-column align-items-center">
            <div class="full-name">
                <h1 class="mb-0"><?php echo esc_html($settings['first_name']); ?></h1>
                <h1 class="mb-0"><?php echo esc_html($settings['last_name']); ?></h1>
            </div>
            <div class="job-title-container">
                <b class="animated-title" id="animated-job-<?php echo $this->get_id(); ?>"><?php echo esc_html($job_titles[0]); ?></b>
            </div>
        </div>
        
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const textElement = document.getElementById('animated-job-<?php echo $this->get_id(); ?>');
            const texts = <?php echo $job_titles_json; ?>;
            const interval = <?php echo $animation_interval; ?>;
            let index = 0;

            if (textElement && texts.length > 1) {
                function changeText() {
                    textElement.classList.add('fade-out');

                    setTimeout(() => {
                        index = (index + 1) % texts.length;
                        textElement.textContent = texts[index];

                        textElement.classList.remove('fade-out');
                        textElement.classList.add('fade-in');

                        setTimeout(() => {
                            textElement.classList.remove('fade-in');
                        }, 600);
                    }, 600);
                }

                setInterval(changeText, interval);
            }
        });
        </script>
        <?php
    }

    protected function _content_template() {
        ?>
        <div class="skill_my_name d-flex flex-column align-items-center">
            <div class="full-name">
                <h1 class="mb-0">{{{ settings.first_name }}}</h1>
                <h1 class="mb-0">{{{ settings.last_name }}}</h1>
            </div>
            <div class="job-title-container">
                <b class="animated-title" id="animated-job-{{ view.getID() }}">{{{ settings.job_titles[0].job_title }}}</b>
            </div>
        </div>
        <?php
    }
}
