<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_image_gallery_slider_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_image_gallery_slider';
    }

    public function get_title() {
        return __( 'اسلایدر گالری تصاویر', 'skill' );
    }

    public function get_icon() {
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    public function get_keywords() {
        return [ 'اسلایدر', 'گالری', 'تصویر', 'skill' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'تصاویر', 'skill' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'gallery',
            [
                'label' => __( 'انتخاب تصاویر', 'skill' ),
                'type' => \Elementor\Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $images = $settings['gallery'];

        if ( empty( $images ) ) {
            echo '<div>' . __( 'هیچ تصویری انتخاب نشده است.', 'skill' ) . '</div>';
            return;
        }
        $main_img = $images[0]['url'];
        $uid = uniqid('skill_slider_');
        ?>
        <div class="skill-image-gallery-slider" id="<?php echo esc_attr($uid); ?>" dir="rtl">
            <style>
                .skill-image-gallery-slider {
                    width: 100%;
                    margin: 0 auto;
                    text-align: center;
                    direction: rtl;
                }
                .skill-slider-main-wrap {
                    position: relative;
                    border-radius: 18px;
                    overflow: hidden;
                    box-shadow: 0 6px 32px 0 rgba(0,0,0,0.13);
                }
                .skill-main-image {
                    width: 100%;
                    aspect-ratio: 16/9;
                    position: relative;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 18px;
                    overflow: hidden;
                    height: auto;
                    min-height: unset;
                }
                .skill-main-image img {
                    width: 100%;
                    height: 100%;
                    position: absolute;
                    left: 0; top: 0;
                    transition: opacity 0.4s, transform 0.5s cubic-bezier(.77,0,.18,1);
                    opacity: 0;
                    z-index: 1;
                    transform: scale(0.95);
                }
                .skill-main-image img.active {
                    opacity: 1;
                    z-index: 2;
                    transform: scale(1);
                }
                .skill-main-image img.zoom-out {
                    opacity: 0;
                    transform: scale(0.95);
                }
                .skill-main-image img.zoom-in {
                    opacity: 0;
                    transform: scale(1.08);
                }
                .skill-slider-arrow {
                    /* Completely remove arrows */
                    display: none !important;
                }
                .skill-thumbnails {
                    display: flex;
                    justify-content: center;
                    gap: 16px;
                    margin-top: 18px;
                }
                .skill-thumbnails img {
                    width: 200px;
                    height: 160px;
                    object-fit: cover;
                    border-radius: 10px;
                    cursor: pointer;
                    border: 2px solid transparent;
                    box-shadow: 0 2px 8px rgba(0,0,0,0.07);
                    opacity: 0.7;
                    transition: border 0.2s, opacity 0.2s, filter 0.3s;
                    filter: grayscale(100%);
                }
                .skill-thumbnails img.active,
                .skill-thumbnails img:hover {
                    border: 2px solid #0073aa;
                    opacity: 1;
                    filter: none;
                }
                @media (max-width: 600px) {
                    .skill-image-gallery-slider {
                        max-width: 98vw;
                    }
                    .skill-thumbnails img {
                        width: 60px;
                        height: 44px;
                    }
                }
            </style>
            <div class="skill-slider-main-wrap">
                <div class="skill-main-image">
                    <?php foreach ( $images as $index => $image ) : ?>
                        <img src="<?php echo esc_url( $image['url'] ); ?>" alt="" data-index="<?php echo $index; ?>" class="<?php echo $index === 0 ? 'active' : ''; ?>">
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="skill-thumbnails">
                <?php foreach ( $images as $index => $image ) : ?>
                    <img src="<?php echo esc_url( $image['url'] ); ?>" alt="" data-index="<?php echo $index; ?>" class="<?php echo $index === 0 ? 'active' : ''; ?>">
                <?php endforeach; ?>
            </div>
            <script>
                (function(){
                    var slider = document.getElementById('<?php echo esc_js($uid); ?>');
                    var mainImgs = slider.querySelectorAll('.skill-main-image img');
                    var thumbs = slider.querySelectorAll('.skill-thumbnails img');
                    var current = 0;
                    var animating = false;

                    function showImage(idx) {
                        if(idx === current || animating) return;
                        animating = true;
                        mainImgs[current].classList.remove('active');
                        mainImgs[current].classList.add('zoom-out');
                        mainImgs[idx].classList.add('zoom-in');
                        setTimeout(function(){
                            mainImgs[idx].classList.remove('zoom-in');
                            mainImgs[idx].classList.add('active');
                            thumbs.forEach(function(t, i){
                                if(i === idx) t.classList.add('active');
                                else t.classList.remove('active');
                            });
                            setTimeout(function(){
                                mainImgs[current].classList.remove('zoom-out');
                                animating = false;
                                current = idx;
                            }, 500);
                        }, 20);
                    }

                    thumbs.forEach(function(thumb, idx){
                        thumb.addEventListener('click', function(){
                            showImage(idx);
                        });
                    });

                })();
            </script>
        </div>
        <?php
    }
}
