<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Box_Shadow;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class skill_customer_reviews_Widget extends Widget_Base {
    // Widget slug
    public function get_name() {
        return 'skill_customer_reviews_new_widget';
    }
    // Widget title
    public function get_title() {
        return esc_html__('نظرات مشتریان من (جدید)', 'skill');
    }
    // Widget icon
    public function get_icon() {
        return 'eicon-comments';
    }
    // Widget category
    public function get_categories() {
        return ['skill-category'];
    }

    // Register widget controls
    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('محتوا', 'skill'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();
        // User image
        $repeater->add_control(
            'user_image',
            [
                'label' => esc_html__('تصویر کاربر', 'skill'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        // User name
        $repeater->add_control(
            'user_name',
            [
                'label' => esc_html__('نام کاربر', 'skill'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('نام نمونه', 'skill'),
                'label_block' => true,
            ]
        );
        // User job
        $repeater->add_control(
            'user_job',
            [
                'label' => esc_html__('سمت/شغل', 'skill'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('برنامه نویس و توسعه دهنده وردپرس', 'skill'),
                'label_block' => true,
            ]
        );
        // User rating
        $repeater->add_control(
            'user_rating',
            [
                'label' => esc_html__('امتیاز (تعداد ستاره)', 'skill'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '5' => '★★★★★',
                    '4' => '★★★★☆',
                    '3' => '★★★☆☆',
                    '2' => '★★☆☆☆',
                    '1' => '★☆☆☆☆',
                ],
                'default' => '5',
            ]
        );
        // User comment
        $repeater->add_control(
            'user_comment',
            [
                'label' => esc_html__('متن نظر', 'skill'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('متن نمونه نظر مشتری...', 'skill'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'reviews',
            [
                'label' => esc_html__('لیست نظرات', 'skill'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'user_name' => 'باربد',
                        'user_job' => 'برنامه نویس و توسعه دهنده وردپرس',
                        'user_rating' => '5',
                        'user_comment' => 'لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد کتابهای زیادی در شصت و سه درصد گذشته حال و آینده',
                        'user_image' => [ 'url' => \Elementor\Utils::get_placeholder_image_src() ],
                    ],
                ],
                'title_field' => '{{{ user_name }}}',
            ]
        );

        // Dynamic main title
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('عنوان اصلی', 'skill'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('آنچه کاربران درمورد من میگن', 'skill'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'main_title_color',
            [
                'label' => esc_html__('رنگ عنوان اصلی', 'skill'),
                'type' => Controls_Manager::COLOR,
                'default' => '#8D8D8D',
                'selectors' => [
                    '{{WRAPPER}} .skill-customer-reviews-slider .skill-customer-reviews-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style section
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('استایل', 'skill'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bg_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه', 'skill'),
                'type' => Controls_Manager::COLOR,
                'default' => '#18161A',
                'selectors' => [
                    '{{WRAPPER}} .skill-customer-reviews-slider' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('رنگ ستاره ها', 'skill'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-customer-reviews-slider, {{WRAPPER}} .skill-customer-reviews-slider *' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .skill-customer-reviews-slider',
            ]
        );
        $this->end_controls_section();
    }

    // Render widget output on the frontend
    protected function render() {
        $settings = $this->get_settings_for_display();
        $id = 'skill-customer-reviews-slider-' . $this->get_id();
        if (empty($settings['reviews'])) return;
        ?>
        <style>
        /* Override any global Swiper backgrounds for this widget only */
        #<?php echo esc_attr($id); ?>.skill-customer-reviews-slider .swiper,
        #<?php echo esc_attr($id); ?>.skill-customer-reviews-slider .swiper-wrapper {
            background: transparent !important;
        }
        </style>
        <div class="skill-customer-reviews-slider" id="<?php echo esc_attr($id); ?>" dir="rtl" style="padding: 40px 0; border-radius: 16px; position: relative;">
            <h2 class="skill-customer-reviews-title" style="text-align:center; font-size:2rem; font-weight:700; margin-bottom:32px;<?php if(!empty($settings['main_title_color'])) echo 'color:'.esc_attr($settings['main_title_color']).';'; ?>">
                <?php echo esc_html($settings['main_title']); ?>
            </h2>
            <div style="position:absolute; top:30px; right:220px; font-size:80px; color:#656689; opacity:0.5;">&#8220;</div>
            <div style="position:absolute; bottom:30px; left:220px; font-size:80px; color:#656689; opacity:0.5;">&#8221;</div>
            <div class="swiper" id="<?php echo esc_attr($id); ?>-swiper">
                <div class="swiper-wrapper">
                    <?php foreach ($settings['reviews'] as $review): ?>
                        <div class="swiper-slide" style="display:flex; flex-direction:column; align-items:center; justify-content:center; min-height:350px;">
                            <?php if (!empty($review['user_image']['url'])): ?>
                                <img src="<?php echo esc_url($review['user_image']['url']); ?>" alt="<?php echo esc_attr($review['user_name']); ?>" style="width:90px; height:90px; border-radius:50%; object-fit:cover; margin-bottom:12px; border:4px solid #232135;">
                            <?php endif; ?>
                            <div style="font-weight:700; color:#2F5BEA; font-size:1.1rem; margin-bottom:2px;"> <?php echo esc_html($review['user_name']); ?> </div>
                            <div style="font-size:0.95rem; color:#bdbdbd; margin-bottom:8px;"> <?php echo esc_html($review['user_job']); ?> </div>
                            <div style="color:#FFD600; font-size:1.3rem; margin-bottom:8px;">
                                <?php for($i=1; $i<=5; $i++): ?>
                                    <?php if($i <= intval($review['user_rating'])): ?>
                                        <span style="font-size:1.3rem;">&#9733;</span>
                                    <?php else: ?>
                                        <span style="font-size:1.3rem; color:#444;">&#9734;</span>
                                    <?php endif; ?>
                                <?php endfor; ?>
                            </div>
                            <div style="max-width:700px; text-align:center; font-size:1.05rem; line-height:2; margin:0 auto; color:#bdbdbd;"> <?php echo esc_html($review['user_comment']); ?> </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <script>
        jQuery(document).ready(function($){
            var $slider = $('#<?php echo esc_js($id); ?>-swiper');
            if ($slider.length && !$slider.hasClass('swiper-initialized')) {
                new Swiper($slider[0], {
                    loop: true,
                    navigation: {
                        nextEl: $slider.find('.swiper-button-next')[0],
                        prevEl: $slider.find('.swiper-button-prev')[0],
                    },
                    rtl: true,
                    slidesPerView: 1,
                    spaceBetween: 0,
                    autoHeight: true,
                });
                $slider.addClass('swiper-initialized');
            }
        });
        </script>
        <?php
    }
}