<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */

/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}

// Get the current post type to determine the appropriate text
$post_type = get_post_type();
$post_type_text = ($post_type === 'project') ? 'پروژه' : 'مقاله';
?>

<!-- Comment Success Message -->
<div id="comment-success-message" class="comment-success-message" style="display: none;">
    <div class="success-content">
        <div class="success-icon">✅</div>
        <div class="success-text">
            <h4><?php _e('دیدگاه شما با موفقیت ثبت شد!', 'skill'); ?></h4>
            <p><?php _e('دیدگاه شما پس از تایید نمایش داده خواهد شد.', 'skill'); ?></p>
        </div>
        <button class="success-close-btn" onclick="hideCommentSuccess()">×</button>
    </div>
</div>

<div id="comments" class="modern-comments-area">

    <?php if ( have_comments() ) : ?>
        <div class="comments-header">
            <h2 class="comments-title">
                <?php
                printf(
                    _nx(
                        $post_type_text . ':  "%2$s"',
                        '%1$s  نظر برای ' . $post_type_text . ':  "%2$s"',
                        get_comments_number(),
                        'comments title',
                        'skill'
                    ),
                    number_format_i18n( get_comments_number() ),
                    '<span>' . get_the_title() . '</span>'
                );
                ?>
            </h2>
            <div class="comments-count">
                <span class="count-badge"><?php echo get_comments_number(); ?></span>
                <span class="count-text"><?php _e('نظر', 'skill'); ?></span>
            </div>
        </div>

        <div class="comments-container">
            <ol class="modern-comment-list">
                <?php
                wp_list_comments( array(
                    'style'       => 'ol',
                    'short_ping'  => true,
                    'avatar_size' => 60,
                    'callback'    => 'modern_comment_callback',
                    'reverse_top_level' => true,
                    'reverse_children' => false,
                ) );
                ?>
            </ol><!-- .comment-list -->
        </div>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
            <nav class="modern-comment-navigation" role="navigation">
                <div class="nav-links">
                    <div class="nav-previous">
                        <?php previous_comments_link( '<span class="nav-arrow">←</span> ' . __( 'نظرات قدیمی‌تر', 'skill' ) ); ?>
                    </div>
                    <div class="nav-next">
                        <?php next_comments_link( __( 'نظرات جدیدتر', 'skill' ) . ' <span class="nav-arrow">→</span>' ); ?>
                    </div>
                </div>
            </nav><!-- .comment-navigation -->
        <?php endif; // Check for comment navigation ?>

        <?php if ( ! comments_open() && get_comments_number() ) : ?>
            <div class="comments-closed-notice">
                <div class="notice-icon">🔒</div>
                <p class="no-comments"><?php _e( 'ارسال نظر بسته شده است.', 'skill' ); ?></p>
            </div>
        <?php endif; ?>

    <?php else : ?>
        <div class="no-comments-section">
            <div class="no-comments-icon">💬</div>
            <h3 class="no-comments-title"><?php _e('هنوز نظری ثبت نشده', 'skill'); ?></h3>
            <p class="no-comments-text"><?php printf(__('اولین نفری باشید که برای این %s نظر می‌دهید!', 'skill'), $post_type_text); ?></p>
        </div>
    <?php endif; // have_comments() ?>

    <div class="modern-comment-form-container">
        <?php 
        comment_form(array(
            'title_reply' => '<span class="form-title-icon">✍️</span> ' . __( 'ارسال نظر', 'skill' ),
            'title_reply_to' => '<span class="form-title-icon">↩️</span> ' . __( 'پاسخ به %s', 'skill' ),
            'cancel_reply_link' => __( 'انصراف', 'skill' ),
            'label_submit' => __( 'ارسال نظر', 'skill' ),
            'comment_field' => '<div class="comment-form-comment"><label for="comment" class="form-label">' . __( 'نظر شما', 'skill' ) . '</label><textarea id="comment" name="comment" class="modern-textarea" placeholder="' . __( 'نظر خود را اینجا بنویسید...', 'skill' ) . '" required></textarea></div>',
            'comment_notes_before' => '<div class="comment-notes"><p class="comment-notes-text">' . __( 'ایمیل شما منتشر نخواهد شد. فیلدهای ضروری علامت‌گذاری شده‌اند *', 'skill' ) . '</p></div>',
            'class_form' => 'modern-comment-form',
            'class_submit' => 'modern-submit-btn',
        )); 
        ?>
    </div>

</div><!-- #comments -->

<script>
// Comment form submission handler
document.addEventListener('DOMContentLoaded', function() {
    const commentForm = document.querySelector('.modern-comment-form');
    if (commentForm) {
        commentForm.addEventListener('submit', function(e) {
            // Show success message after form submission
            setTimeout(function() {
                showCommentSuccess();
            }, 1000);
        });
    }
});

// Show success message
function showCommentSuccess() {
    const successMessage = document.getElementById('comment-success-message');
    if (successMessage) {
        successMessage.style.display = 'flex';
        successMessage.classList.add('show');
        
        // Auto hide after 5 seconds
        setTimeout(function() {
            hideCommentSuccess();
        }, 5000);
    }
}

// Hide success message
function hideCommentSuccess() {
    const successMessage = document.getElementById('comment-success-message');
    if (successMessage) {
        successMessage.classList.remove('show');
        setTimeout(function() {
            successMessage.style.display = 'none';
        }, 300);
    }
}

// Check if comment was successfully submitted (for page reloads)
window.addEventListener('load', function() {
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('comment') === 'success') {
        showCommentSuccess();
    }
});
</script>

<?php
// Custom comment callback function
function modern_comment_callback($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    ?>
    <li <?php comment_class('modern-comment-item'); ?> id="comment-<?php comment_ID(); ?>">
        <article class="modern-comment-body">
            <div class="comment-avatar">
                <?php echo get_avatar($comment, $args['avatar_size']); ?>
            </div>
            
            <div class="comment-content">
                <div class="comment-meta">
                    <div class="comment-author">
                        <?php printf('<cite class="author-name">%s</cite>', get_comment_author_link()); ?>
                        <?php if (get_comment_author_url() && get_comment_author_url() != 'http://') : ?>
                            <a href="<?php comment_author_url(); ?>" class="author-website" target="_blank" rel="nofollow">
                                <span class="website-icon">🌐</span>
                            </a>
                        <?php endif; ?>
                    </div>
                    
                    <div class="comment-meta-right">
                        <time class="comment-date" datetime="<?php comment_time('c'); ?>">
                            <span class="date-icon">📅</span>
                            <?php echo get_comment_date('j F Y'); ?>
                        </time>
                        
                        <?php if ($comment->comment_approved == '0') : ?>
                            <span class="comment-awaiting-moderation">
                                <span class="moderation-icon">⏳</span>
                                <?php _e('در انتظار تایید', 'skill'); ?>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="comment-text">
                    <?php comment_text(); ?>
                </div>
                
                <div class="comment-actions">
                    <?php
                    comment_reply_link(array_merge($args, array(
                        'reply_text' => '<span class="reply-icon">↩️</span> ' . __('پاسخ', 'skill'),
                        'depth' => $depth,
                        'max_depth' => $args['max_depth'],
                        'before' => '<span class="reply-link">',
                        'after' => '</span>'
                    )));
                    ?>
                    
                    <?php edit_comment_link('<span class="edit-icon">✏️</span> ' . __('ویرایش', 'skill'), '<span class="edit-link">', '</span>'); ?>
                </div>
            </div>
        </article>
    <?php
}
?>
