/**
 * WooCommerce Custom JavaScript
 * Enhances product gallery zoom functionality
 * Compatible with existing theme styles
 */

jQuery(document).ready(function($) {
    
    // Wait for WooCommerce to be fully loaded
    setTimeout(function() {
        
        // Ensure WooCommerce product gallery zoom works properly
        if ($('.woocommerce-product-gallery').length) {
            
            // Initialize zoom on product images
            $('.woocommerce-product-gallery__image').each(function() {
                var $image = $(this).find('img');
                
                if ($image.length) {
                    // Add zoom functionality using native WooCommerce zoom
                    if (typeof $.fn.zoom !== 'undefined') {
                        $image.parent().zoom({
                            url: $image.attr('src'),
                            magnify: 1.5
                        });
                    }
                }
            });
            
            // Enhance zoom trigger with lightbox
            $('.woocommerce-product-gallery__trigger').on('click', function(e) {
                e.preventDefault();
                var $image = $(this).closest('.woocommerce-product-gallery__image').find('img');
                if ($image.length) {
                    var imageUrl = $image.attr('src');
                    if (imageUrl) {
                        // Create lightbox effect
                        var $lightbox = $('<div class="woocommerce-lightbox"></div>');
                        var $lightboxImg = $('<img src="' + imageUrl + '" />');
                        
                        $lightbox.append($lightboxImg);
                        $('body').append($lightbox);
                        
                        // Close lightbox on click
                        $lightbox.on('click', function() {
                            $(this).remove();
                        });
                    }
                }
            });
            
            // Add hover zoom effect
            $('.woocommerce-product-gallery__image img').hover(
                function() {
                    $(this).css('transform', 'scale(1.05)');
                },
                function() {
                    $(this).css('transform', 'scale(1)');
                }
            );
        }
        
        // Ensure flexslider works properly
        if ($('.woocommerce-product-gallery').length && typeof $.fn.flexslider !== 'undefined') {
            $('.woocommerce-product-gallery').flexslider({
                animation: "slide",
                controlNav: true,
                directionNav: false,
                smoothHeight: true,
                touch: true
            });
        }
        
        // Add custom zoom cursor
        $('.woocommerce-product-gallery__image img').css('cursor', 'zoom-in');
        
        // Enhance product gallery navigation
        $('.woocommerce-product-gallery .flex-control-nav img').on('click', function() {
            var targetIndex = $(this).parent().index();
            if (typeof $.fn.flexslider !== 'undefined') {
                $('.woocommerce-product-gallery').flexslider(targetIndex);
            }
        });
        
    }, 500); // Wait 500ms for WooCommerce to load
    
    // Add keyboard navigation for zoom
    $(document).keydown(function(e) {
        if (e.keyCode === 27) { // ESC key
            $('.woocommerce-lightbox').remove();
        }
    });
    
    // Ensure responsive behavior
    $(window).resize(function() {
        if ($('.woocommerce-product-gallery').length && typeof $.fn.flexslider !== 'undefined') {
            $('.woocommerce-product-gallery').flexslider('resize');
        }
    });
    
});

// Add CSS for lightbox - compatible with existing styles
jQuery('<style>')
    .prop('type', 'text/css')
    .html(`
        .woocommerce-lightbox {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.9);
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
        }
        .woocommerce-lightbox img {
            max-width: 90%;
            max-height: 90%;
            object-fit: contain;
        }
    `)
    .appendTo('head'); 